/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.menu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import net.jlxxw.wechat.dto.menu.MenuDTO;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.menu.MenuResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class MenuManager {
    private static final Logger logger = LoggerFactory.getLogger(MenuManager.class);
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private RestTemplate restTemplate;

    public WeChatResponse createMenu(@NotEmpty(message="\u521b\u5efa\u83dc\u5355\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u521b\u5efa\u83dc\u5355\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a") List<MenuDTO> list) throws WeChatException, ParamCheckException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("button", list);
        String json = JSON.toJSONString((Object)jsonObject);
        LoggerUtils.debug(logger, "\u521b\u5efa\u516c\u4f17\u53f7\u83dc\u5355\uff0c\u8bf7\u6c42\u53c2\u6570:{}", json);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/menu/create?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u521b\u5efa\u516c\u4f17\u53f7\u83dc\u5355\uff0c\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse weChatResponse = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (StringUtils.isNotBlank((CharSequence)body) && !weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }

    public WeChatResponse deleteMenu() throws WeChatException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/menu/delete?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)entity.getBody();
        LoggerUtils.debug(logger, "\u5220\u9664\u516c\u4f17\u53f7\u83dc\u5355\uff0c\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (StringUtils.isNotBlank((CharSequence)body) && !response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public MenuResponse getMenu() throws WeChatException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)entity.getBody();
        LoggerUtils.debug(logger, "\u83b7\u53d6\u516c\u4f17\u53f7\u83dc\u5355\uff0c\u5e94\u7b54\u7ed3\u679c:{}", body);
        MenuResponse response = (MenuResponse)JSONObject.parseObject((String)body, MenuResponse.class);
        if (StringUtils.isNotBlank((CharSequence)body) && !response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }
}

