/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.dto.customer;

import java.util.ArrayList;
import net.jlxxw.wechat.dto.customer.ArticlesDTO;
import net.jlxxw.wechat.dto.customer.ImageDTO;
import net.jlxxw.wechat.dto.customer.MenuDTO;
import net.jlxxw.wechat.dto.customer.MiniProgramPageDTO;
import net.jlxxw.wechat.dto.customer.MpnewsDTO;
import net.jlxxw.wechat.dto.customer.MusicDTO;
import net.jlxxw.wechat.dto.customer.NewsDTO;
import net.jlxxw.wechat.dto.customer.TextDTO;
import net.jlxxw.wechat.dto.customer.VideoDTO;
import net.jlxxw.wechat.dto.customer.VoiceDTO;
import net.jlxxw.wechat.dto.customer.WxCardDTO;

public class CustomerMessageDTO {
    private String touser;
    private String msgtype;
    private NewsDTO news;
    private TextDTO text;
    private ImageDTO image;
    private VoiceDTO voice;
    private VideoDTO video;
    private MusicDTO music;
    private MpnewsDTO mpnews;
    private MenuDTO msgmenu;
    private WxCardDTO wxcard;
    private MiniProgramPageDTO miniprogrampage;

    public TextDTO getText() {
        return this.text;
    }

    public void setText(TextDTO text) {
        this.text = text;
    }

    public String getTouser() {
        return this.touser;
    }

    public void setTouser(String touser) {
        this.touser = touser;
    }

    public String getMsgtype() {
        return this.msgtype;
    }

    public void setMsgtype(String msgtype) {
        this.msgtype = msgtype;
    }

    public NewsDTO getNews() {
        return this.news;
    }

    public void setNews(NewsDTO newsDTO) {
        this.news = newsDTO;
    }

    public ImageDTO getImage() {
        return this.image;
    }

    public void setImage(ImageDTO image) {
        this.image = image;
    }

    public VoiceDTO getVoice() {
        return this.voice;
    }

    public void setVoice(VoiceDTO voice) {
        this.voice = voice;
    }

    public VideoDTO getVideo() {
        return this.video;
    }

    public void setVideo(VideoDTO video) {
        this.video = video;
    }

    public MusicDTO getMusic() {
        return this.music;
    }

    public void setMusic(MusicDTO music) {
        this.music = music;
    }

    public MpnewsDTO getMpnews() {
        return this.mpnews;
    }

    public void setMpnews(MpnewsDTO mpnews) {
        this.mpnews = mpnews;
    }

    public MenuDTO getMsgmenu() {
        return this.msgmenu;
    }

    public void setMsgmenu(MenuDTO msgmenu) {
        this.msgmenu = msgmenu;
    }

    public WxCardDTO getWxcard() {
        return this.wxcard;
    }

    public void setWxcard(WxCardDTO wxcard) {
        this.wxcard = wxcard;
    }

    public MiniProgramPageDTO getMiniprogrampage() {
        return this.miniprogrampage;
    }

    public void setMiniprogrampage(MiniProgramPageDTO miniprogrampage) {
        this.miniprogrampage = miniprogrampage;
    }

    private CustomerMessageDTO() {
    }

    private CustomerMessageDTO(String touser, String msgtype, NewsDTO newsDTO) {
        this.touser = touser;
        this.msgtype = msgtype;
        this.news = newsDTO;
    }

    private CustomerMessageDTO(String touser, String msgtype, TextDTO text) {
        this.touser = touser;
        this.msgtype = msgtype;
        this.text = text;
    }

    private CustomerMessageDTO(String touser, String msgtype, ImageDTO image) {
        this.touser = touser;
        this.msgtype = msgtype;
        this.image = image;
    }

    public static CustomerMessageDTO buildNews(String openId, ArticlesDTO articlesDTO) {
        NewsDTO newsDTO = new NewsDTO();
        ArrayList<ArticlesDTO> articlesDTOList = new ArrayList<ArticlesDTO>();
        articlesDTOList.add(articlesDTO);
        newsDTO.setArticles(articlesDTOList);
        return new CustomerMessageDTO(openId, "news", newsDTO);
    }

    public static CustomerMessageDTO buildText(String openId, String text) {
        TextDTO dto = new TextDTO();
        dto.setContent(text);
        return new CustomerMessageDTO(openId, "text", dto);
    }

    public static CustomerMessageDTO buildImage(String openId, String mediaId) {
        ImageDTO dto = new ImageDTO();
        dto.setMediaId(mediaId);
        return new CustomerMessageDTO(openId, "image", dto);
    }

    public static CustomerMessageDTO buildVoice(String openId, VoiceDTO dto) {
        CustomerMessageDTO customerMessageDTO = new CustomerMessageDTO();
        customerMessageDTO.setTouser(openId);
        customerMessageDTO.setMsgtype("voice");
        customerMessageDTO.setVoice(dto);
        return customerMessageDTO;
    }

    public static CustomerMessageDTO buildVideo(String openId, VideoDTO dto) {
        CustomerMessageDTO customerMessageDTO = new CustomerMessageDTO();
        customerMessageDTO.setTouser(openId);
        customerMessageDTO.setMsgtype("video");
        customerMessageDTO.setVideo(dto);
        return customerMessageDTO;
    }

    public static CustomerMessageDTO buildMusic(String openId, MusicDTO dto) {
        CustomerMessageDTO customerMessageDTO = new CustomerMessageDTO();
        customerMessageDTO.setTouser(openId);
        customerMessageDTO.setMsgtype("music");
        customerMessageDTO.setMusic(dto);
        return customerMessageDTO;
    }

    public static CustomerMessageDTO buildMpNews(String openId, MpnewsDTO dto) {
        CustomerMessageDTO customerMessageDTO = new CustomerMessageDTO();
        customerMessageDTO.setTouser(openId);
        customerMessageDTO.setMsgtype("mpnews");
        customerMessageDTO.setMpnews(dto);
        return customerMessageDTO;
    }

    public static CustomerMessageDTO buildMpNews(String openId, String mediaId) {
        MpnewsDTO dto = new MpnewsDTO();
        dto.setMediaId(mediaId);
        return CustomerMessageDTO.buildMpNews(openId, dto);
    }

    public static CustomerMessageDTO buildMsgMenu(String openId, MenuDTO dto) {
        CustomerMessageDTO customerMessageDTO = new CustomerMessageDTO();
        customerMessageDTO.setTouser(openId);
        customerMessageDTO.setMsgtype("msgmenu");
        customerMessageDTO.setMsgmenu(dto);
        return customerMessageDTO;
    }

    public static CustomerMessageDTO buildWxCard(String openId, WxCardDTO dto) {
        CustomerMessageDTO customerMessageDTO = new CustomerMessageDTO();
        customerMessageDTO.setTouser(openId);
        customerMessageDTO.setMsgtype("wxcard");
        customerMessageDTO.setWxcard(dto);
        return customerMessageDTO;
    }

    public static CustomerMessageDTO buildMiniProgramPage(String openId, MiniProgramPageDTO dto) {
        CustomerMessageDTO customerMessageDTO = new CustomerMessageDTO();
        customerMessageDTO.setTouser(openId);
        customerMessageDTO.setMsgtype("miniprogrampage");
        customerMessageDTO.setMiniprogrampage(dto);
        return customerMessageDTO;
    }
}

