/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.util;

import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtils {
    private static final Logger log = LoggerFactory.getLogger(RSAUtils.class);

    public static String encode(String src, String publicKey) throws Exception {
        byte[] rsaPublicKeyEncoded = Base64.getDecoder().decode(publicKey);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(rsaPublicKeyEncoded);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, keyFactory.generatePublic(x509EncodedKeySpec));
        byte[] resultBytes = cipher.doFinal(src.getBytes());
        return Hex.encodeHexString((byte[])resultBytes);
    }

    public static String decode(String src, String privateKey) throws Exception {
        byte[] rsaPrivateKeyEncoded = Base64.getDecoder().decode(privateKey);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(rsaPrivateKeyEncoded);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, keyFactory.generatePrivate(pkcs8EncodedKeySpec));
        byte[] resultBytes = cipher.doFinal(Hex.decodeHex((char[])src.toCharArray()));
        return new String(resultBytes);
    }
}

