/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import net.jlxxw.wechat.component.BatchExecutor;
import net.jlxxw.wechat.enums.LanguageEnum;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.user.SubscriptionResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class UserManager {
    private static final Logger logger = LoggerFactory.getLogger(UserManager.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private BatchExecutor batchExecutor;

    public Set<String> findAll() throws WeChatException {
        HashSet<String> openIdSet = new HashSet<String>();
        int current = 0;
        int totle = 1;
        String nextOpenId = "";
        while (current < totle) {
            String token = this.weChatTokenManager.getTokenFromLocal();
            String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/user/get?access_token={0}&next_openid={1}", token, nextOpenId);
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
            String body = (String)forEntity.getBody();
            JSONObject resultData = JSONObject.parseObject((String)body);
            if (resultData.getInteger("errcode") == null || resultData.getInteger("errcode") == 0) {
                JSONArray array;
                totle = resultData.getInteger("total");
                nextOpenId = resultData.getString("next_openid");
                logger.info("total:" + totle + ",current:" + (current += resultData.getInteger("count").intValue()) + ",nextId:" + nextOpenId + ",size:" + openIdSet.size());
                JSONObject data = resultData.getJSONObject("data");
                if (!Objects.nonNull(data) || CollectionUtils.isEmpty((Collection)(array = data.getJSONArray("openid")))) continue;
                array.forEach(o -> openIdSet.add(o.toString()));
                continue;
            }
            WeChatException weChatException = new WeChatException("\u83b7\u53d6\u5168\u90e8openId\u5931\u8d25\uff0c\u5fae\u4fe1\u8fd4\u56de\u503c:" + resultData.toJSONString());
            weChatException.setErrorCode(resultData.getInteger("errcode"));
            throw weChatException;
        }
        return openIdSet;
    }

    public List<SubscriptionResponse> findUserInfo(@NotEmpty(message="\u5f85\u67e5\u8be2\u5f85openId\u5217\u8868\u4e0d\u5e94\u4e3a\u7a7a") @NotEmpty(message="\u5f85\u67e5\u8be2\u5f85openId\u5217\u8868\u4e0d\u5e94\u4e3a\u7a7a") List<String> openIdList, @NotNull(message="\u8bed\u8a00\u679a\u4e3e\u4e0d\u5e94\u4e3a\u7a7a") @NotNull(message="\u8bed\u8a00\u679a\u4e3e\u4e0d\u5e94\u4e3a\u7a7a") LanguageEnum languageEnum) throws WeChatException, ParamCheckException {
        LinkedList<SubscriptionResponse> result = new LinkedList<SubscriptionResponse>();
        if (CollectionUtils.isEmpty(openIdList)) {
            return result;
        }
        CountDownLatch countDownLatch = new CountDownLatch(openIdList.size());
        this.batchExecutor.execute(true, openIdList, tempList -> {
            JSONObject requestParam = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (String openId : tempList) {
                JSONObject param = new JSONObject();
                param.put("openid", (Object)openId);
                param.put("lang", (Object)languageEnum.getCode());
                jsonArray.add((Object)param);
            }
            requestParam.put("user_list", (Object)jsonArray);
            String token = this.weChatTokenManager.getTokenFromLocal();
            String url = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=" + token;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String json = JSON.toJSONString((Object)requestParam);
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            JSONObject resultData = JSONObject.parseObject((String)((String)responseEntity.getBody()));
            WeChatResponse response = (WeChatResponse)resultData.toJavaObject(WeChatResponse.class);
            if (!response.isSuccessful()) {
                tempList.forEach(x -> countDownLatch.countDown());
                throw new WeChatException(response);
            }
            JSONArray infoList = resultData.getJSONArray("user_info_list");
            List subscriptionUsers = JSONArray.parseArray((String)JSON.toJSONString((Object)infoList), SubscriptionResponse.class);
            result.addAll(subscriptionUsers);
            tempList.forEach(x -> countDownLatch.countDown());
        }, 100L);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public SubscriptionResponse getUserInfo(@NotBlank(message="\u5f85\u67e5\u8be2\u5f85openId\u4e0d\u5e94\u4e3a\u7a7a") @NotBlank(message="\u5f85\u67e5\u8be2\u5f85openId\u4e0d\u5e94\u4e3a\u7a7a") String openId, @NotNull(message="\u8bed\u8a00\u9009\u62e9\u4e0d\u5e94\u4e3a\u7a7a") @NotNull(message="\u8bed\u8a00\u9009\u62e9\u4e0d\u5e94\u4e3a\u7a7a") LanguageEnum languageEnum) throws WeChatException, ParamCheckException {
        if (StringUtils.isBlank((CharSequence)openId)) {
            return null;
        }
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token={0}&openid={1}&lang={2}", token, openId, languageEnum.getCode());
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)forEntity.getBody();
        SubscriptionResponse response = (SubscriptionResponse)body.toJavaObject(SubscriptionResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }
}

