/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.tag;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.function.user.UserManager;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.tag.Tag;
import net.jlxxw.wechat.response.tag.TagResponse;
import net.jlxxw.wechat.response.tag.TagUserResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class TagManager {
    private static final Logger logger = LoggerFactory.getLogger(UserManager.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    public TagResponse createTag(@NotBlank(message="\u6807\u7b7e\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=30, message="\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26") @NotBlank(message="\u6807\u7b7e\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=30, message="\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26") String tagValue) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/tags/create?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u521b\u5efa\u516c\u4f17\u53f7\u6807\u7b7eurl:{}", url);
        JSONObject requestParam = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("name", (Object)tagValue);
        requestParam.put("tag", (Object)param);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)requestParam);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u521b\u5efa\u516c\u4f17\u53f7\u6807\u7b7e\u5e94\u7b54\u7ed3\u679c:{}", body);
        TagResponse response = (TagResponse)JSONObject.parseObject((String)body, TagResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public List<Tag> getTag() throws WeChatException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/tags/get?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u83b7\u53d6\u516c\u4f17\u53f7\u5df2\u521b\u5efa\u7684\u6807\u7b7eurl:{}", url);
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)entity.getBody();
        LoggerUtils.debug(logger, "\u83b7\u53d6\u516c\u4f17\u53f7\u5df2\u521b\u5efa\u7684\u6807\u7b7e\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse weChatResponse = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        JSONObject response = JSONObject.parseObject((String)body);
        return response.getJSONArray("tags").toJavaList(Tag.class);
    }

    public WeChatResponse updateTag(@NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") Integer id, @NotBlank(message="\u6807\u7b7e\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=30, message="\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26") @NotBlank(message="\u6807\u7b7e\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=30, message="\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26") String tagValue) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/tags/update?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u66f4\u65b0\u6807\u7b7eurl:{}", url);
        JSONObject requestParam = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("name", (Object)tagValue);
        param.put("id", (Object)id);
        requestParam.put("tag", (Object)param);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)requestParam);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u66f4\u65b0\u6807\u7b7e\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public WeChatResponse delete(@NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") Integer id) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/tags/delete?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u5220\u9664\u6807\u7b7eurl:{}", url);
        JSONObject requestParam = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("id", (Object)id);
        requestParam.put("tag", (Object)param);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)requestParam);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u5220\u9664\u6807\u7b7e\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public TagUserResponse getTagUser(@NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") Integer tagId, String nextOpenId) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u83b7\u53d6\u6807\u7b7e\u4e0b\u7c89\u4e1d\u5217\u8868url:{}", url);
        JSONObject requestParam = new JSONObject();
        requestParam.put("tagid", (Object)tagId);
        requestParam.put("next_openid", (Object)nextOpenId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)requestParam);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u53d6\u6807\u7b7e\u4e0b\u7c89\u4e1d\u5217\u8868\u5e94\u7b54\u7ed3\u679c:{}", body);
        TagUserResponse response = (TagUserResponse)JSONObject.parseObject((String)body, TagUserResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public WeChatResponse batchTagging(@NotEmpty(message="\u7528\u6237id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=50, message="\u6bcf\u6b21\u4f20\u5165\u7684 openid \u5217\u8868\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc750\u4e2a") @NotEmpty(message="\u7528\u6237id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=50, message="\u6bcf\u6b21\u4f20\u5165\u7684 openid \u5217\u8868\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc750\u4e2a") List<String> openIdList, @NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") Integer tagId) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u7528\u6237\u6279\u91cf\u6253\u6807\u7b7eurl:{}", url);
        JSONObject requestParam = new JSONObject();
        requestParam.put("openid_list", openIdList);
        requestParam.put("tagid", (Object)tagId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)requestParam);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u7528\u6237\u6279\u91cf\u6253\u6807\u7b7e\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public WeChatResponse batchUnTagging(@NotEmpty(message="\u7528\u6237id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=50, message="\u6bcf\u6b21\u4f20\u5165\u7684 openid \u5217\u8868\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc750\u4e2a") @NotEmpty(message="\u7528\u6237id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=50, message="\u6bcf\u6b21\u4f20\u5165\u7684 openid \u5217\u8868\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc750\u4e2a") List<String> openIdList, @NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a") Integer tagId) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u6279\u91cf\u53d6\u6d88\u7528\u6237\u6807\u7b7eurl:{}", url);
        JSONObject requestParam = new JSONObject();
        requestParam.put("openid_list", openIdList);
        requestParam.put("tagid", (Object)tagId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)requestParam);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u6279\u91cf\u53d6\u6d88\u7528\u6237\u6807\u7b7e\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public List<Integer> getUserTags(String openId) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/tags/getidlist?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u83b7\u53d6\u7528\u6237\u8eab\u4e0a\u7684\u6807\u7b7eurl:{}", url);
        JSONObject requestParam = new JSONObject();
        requestParam.put("openid", (Object)openId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)requestParam);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u83b7\u53d6\u7528\u6237\u8eab\u4e0a\u7684\u6807\u7b7e\u5e94\u7b54\u7ed3\u679c:{}", body);
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        JSONObject responseObject = JSONObject.parseObject((String)body);
        return responseObject.getJSONArray("tagid_list").toJavaList(Integer.class);
    }
}

