/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.schedul;

import java.time.LocalDateTime;
import java.util.Date;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.mapper.TokenMapper;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@ConditionalOnProperty(prefix="we-chat", name={"enable-default-token-manager"}, havingValue="true")
public class ScheduledUpdateToken {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledUpdateToken.class);
    private TokenMapper tokenMapper;
    private WeChatTokenManager weChatTokenManager;

    public ScheduledUpdateToken(TokenMapper tokenMapper, WeChatTokenManager weChatTokenManager) {
        this.tokenMapper = tokenMapper;
        this.weChatTokenManager = weChatTokenManager;
    }

    @Scheduled(cron="0 0 */2 * * ?")
    public void updateToken() throws WeChatException {
        Date date = this.tokenMapper.lockSelectMaxDate();
        if (date == null) {
            String token = this.weChatTokenManager.getTokenFromWeiXin();
            this.weChatTokenManager.saveToken(token);
            LoggerUtils.info(logger, "\u66f4\u65b0token\u6210\u529f\uff0c\u5f53\u524d\u65f6\u95f4:{}", LocalDateTime.now());
            String ticket = this.weChatTokenManager.getJsApiTicketFromWeiXin();
            this.weChatTokenManager.saveJsApiTicket(ticket);
            LoggerUtils.info(logger, "\u66f4\u65b0jsApiTicket\u6210\u529f,\u5f53\u524d\u65f6\u95f4:{}", LocalDateTime.now());
            return;
        }
        long dbTime = date.getTime();
        long current = System.currentTimeMillis();
        if (current - dbTime < 10800L) {
            return;
        }
        String token = this.weChatTokenManager.getTokenFromWeiXin();
        this.weChatTokenManager.saveToken(token);
        LoggerUtils.info(logger, "\u66f4\u65b0token\u6210\u529f\uff0c\u5f53\u524d\u65f6\u95f4:{}", LocalDateTime.now());
        String ticket = this.weChatTokenManager.getJsApiTicketFromWeiXin();
        this.weChatTokenManager.saveJsApiTicket(ticket);
        LoggerUtils.info(logger, "\u66f4\u65b0jsApiTicket\u6210\u529f,\u5f53\u524d\u65f6\u95f4:{}", LocalDateTime.now());
    }
}

