/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.qrcode;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.qrcode.QrCodeResponse;
import net.jlxxw.wechat.response.qrcode.TempQrCodeResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class QrcodeManager {
    private static final Logger logger = LoggerFactory.getLogger(QrcodeManager.class);
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private RestTemplate restTemplate;

    public TempQrCodeResponse createTempStringQrcode(@NotBlank(message="\u81ea\u5b9a\u4e49\u7684eventKey\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u81ea\u5b9a\u4e49\u7684eventKey\u4e0d\u80fd\u4e3a\u7a7a") String eventKey, @NotNull(message="\u81ea\u5b9a\u4e49\u7684\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a") @Max(value=2592000L, message="\u6700\u5927\u6709\u6548\u503c\u4e0d\u80fd\u8d85\u8fc72592000\u79d2(30\u5929)\uff0c\u8d85\u8fc7\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a2592000") @Min(value=60L, message="\u6700\u5c0f\u6709\u6548\u503c\u4e3a60\uff0c\u5c0f\u4e8e60\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a60") @NotNull(message="\u81ea\u5b9a\u4e49\u7684\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a") @Max(value=2592000L, message="\u6700\u5927\u6709\u6548\u503c\u4e0d\u80fd\u8d85\u8fc72592000\u79d2(30\u5929)\uff0c\u8d85\u8fc7\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a2592000") @Min(value=60L, message="\u6700\u5c0f\u6709\u6548\u503c\u4e3a60\uff0c\u5c0f\u4e8e60\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a60") Long expireSecond) throws WeChatException, ParamCheckException {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        String json = object.toJSONString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u521b\u5efa\u4e00\u4e2a\u4e34\u65f6\u4e8c\u7ef4\u7801,eventKey:{},\u8fd4\u56de\u7ed3\u679c:{}", eventKey, body);
        TempQrCodeResponse response = (TempQrCodeResponse)JSONObject.parseObject((String)body, TempQrCodeResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public TempQrCodeResponse createTempIdQrcode(@NotNull(message="\u81ea\u5b9a\u4e49\u7684id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u81ea\u5b9a\u4e49\u7684id\u4e0d\u80fd\u4e3a\u7a7a") Long id, @NotNull(message="\u81ea\u5b9a\u4e49\u7684\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a") @Max(value=2592000L, message="\u6700\u5927\u6709\u6548\u503c\u4e0d\u80fd\u8d85\u8fc72592000\u79d2(30\u5929)\uff0c\u8d85\u8fc7\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a2592000") @Min(value=60L, message="\u6700\u5c0f\u6709\u6548\u503c\u4e3a60\uff0c\u5c0f\u4e8e60\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a60") @NotNull(message="\u81ea\u5b9a\u4e49\u7684\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a") @Max(value=2592000L, message="\u6700\u5927\u6709\u6548\u503c\u4e0d\u80fd\u8d85\u8fc72592000\u79d2(30\u5929)\uff0c\u8d85\u8fc7\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a2592000") @Min(value=60L, message="\u6700\u5c0f\u6709\u6548\u503c\u4e3a60\uff0c\u5c0f\u4e8e60\u4f1a\u81ea\u52a8\u8f6c\u6362\u4e3a60") Long expireSecond) throws WeChatException, ParamCheckException {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        String json = object.toJSONString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u521b\u5efa\u4e00\u4e2a\u4e34\u65f6\u4e8c\u7ef4\u7801,id:{},\u8fd4\u56de\u7ed3\u679c:{}", id, body);
        TempQrCodeResponse response = (TempQrCodeResponse)JSONObject.parseObject((String)body, TempQrCodeResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public QrCodeResponse createStringQrcode(@NotBlank(message="\u81ea\u5b9a\u4e49\u7684eventKey\uff0c\u4e0d\u5e94\u8be5\u4e3a\u7a7a") @NotBlank(message="\u81ea\u5b9a\u4e49\u7684eventKey\uff0c\u4e0d\u5e94\u8be5\u4e3a\u7a7a") String eventKey) throws WeChatException, ParamCheckException {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        String json = object.toJSONString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u521b\u5efa\u4e00\u4e2a\u6c38\u4e45\u4e8c\u7ef4\u7801,eventKey:{},\u8fd4\u56de\u7ed3\u679c:{}", eventKey, body);
        QrCodeResponse response = (QrCodeResponse)JSONObject.parseObject((String)body, QrCodeResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public QrCodeResponse createIdQrcode(@NotNull(message="\u4e8c\u7ef4\u7801id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4e8c\u7ef4\u7801id\u4e0d\u80fd\u4e3a\u7a7a") Long id) throws WeChatException, ParamCheckException {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        String json = object.toJSONString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u521b\u5efa\u4e00\u4e2a\u6c38\u4e45\u4e8c\u7ef4\u7801,id:{},\u8fd4\u56de\u7ed3\u679c:{}", id, body);
        QrCodeResponse response = (QrCodeResponse)JSONObject.parseObject((String)body, QrCodeResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }
}

