/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.feign;

import net.jlxxw.wechat.dto.customer.CustomerMessageDTO;
import net.jlxxw.wechat.dto.template.WeChatTemplateDTO;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.token.WeChatTokenResponse;
import net.jlxxw.wechat.response.user.SubscriptionResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value="wechat-api", url="https://api.weixin.qq.com")
public interface WechatFeignClient {
    @PostMapping(value={"cgi-bin/message/template/send?access_token={token}"})
    public WeChatResponse sendTemplate(@PathVariable(value="token") String var1, @RequestBody WeChatTemplateDTO var2);

    @PostMapping(value={"cgi-bin/message/custom/send?access_token={token}"})
    public WeChatResponse sendCustomerMessage(@PathVariable(value="token") String var1, @RequestBody CustomerMessageDTO var2);

    @GetMapping(value={"cgi-bin/token?grant_type=client_credential&appid={appId}&secret={appSecret}"})
    public WeChatTokenResponse getToken(@PathVariable(value="appId") String var1, @PathVariable(value="appSecret") String var2);

    @GetMapping(value={"cgi-bin/ticket/getticket?access_token={token}&type=jsapi"})
    public WeChatTokenResponse getTicket(@PathVariable(value="token") String var1);

    @GetMapping(value={"cgi-bin/user/info?access_token={token}&openid={openId}&lang=zh_CN"})
    public SubscriptionResponse selectByOpenId(@PathVariable(value="token") String var1, @PathVariable(value="openId") String var2);
}

