/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.token;

import javax.annotation.PostConstruct;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.feign.WechatFeignClient;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.mapper.TokenMapper;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.response.token.WeChatTokenResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"tokenMapper", "weChatProperties"})
@ConditionalOnProperty(prefix="we-chat", value={"enable-default-token-manager"}, havingValue="true")
@Component(value="weChatTokenManager")
public class DefaultWeChatTokenManagerImpl
implements WeChatTokenManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWeChatTokenManagerImpl.class);
    @Autowired
    private WeChatProperties weChatProperties;
    @Autowired
    private TokenMapper tokenMapper;
    @Autowired
    private WechatFeignClient wechatFeignClient;

    @PostConstruct
    public void postConstruct() {
        this.tokenMapper.createTokenTable();
        LoggerUtils.info(logger, "\u5df2\u81ea\u52a8\u521b\u5efa token \u8868", new Object[0]);
        this.tokenMapper.createJsApiTicketTable();
        LoggerUtils.info(logger, "\u5df2\u81ea\u52a8\u521b\u5efa js_api \u8868", new Object[0]);
    }

    @Override
    public void saveToken(String token) {
        this.tokenMapper.insertToken(token);
    }

    @Override
    public String getTokenFromWeiXin() throws WeChatException {
        WeChatTokenResponse tokenResponse = this.wechatFeignClient.getToken(this.weChatProperties.getAppId(), this.weChatProperties.getSecret());
        if (tokenResponse.isSuccessful()) {
            return tokenResponse.getAccessToken();
        }
        throw new WeChatException(tokenResponse.getErrcode(), tokenResponse.getErrmsg());
    }

    @Override
    public String getTokenFromLocal() {
        return this.tokenMapper.getToken();
    }

    @Override
    public void saveJsApiTicket(String jsApiTicket) {
        this.tokenMapper.insertJsApiTicket(jsApiTicket);
    }

    @Override
    public String getJsApiTicketFromWeiXin() throws WeChatException {
        WeChatTokenResponse tokenResponse = this.wechatFeignClient.getTicket(this.getTokenFromLocal());
        if (tokenResponse.isSuccessful()) {
            return tokenResponse.getTicket();
        }
        throw new WeChatException(tokenResponse.getErrcode(), tokenResponse.getErrmsg());
    }

    @Override
    public String getJsApiTicketFromLocal() {
        return this.tokenMapper.getJsApiTicket();
    }
}

