/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.push;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.validation.constraints.NotNull;
import net.jlxxw.wechat.component.BatchExecutor;
import net.jlxxw.wechat.dto.customer.CustomerMessageDTO;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lazy
@DependsOn(value={"weChatTokenManager"})
@Component
public class SyncPushCustomer {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BatchExecutor batchExecutor;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    public WeChatResponse pushCustomer(@NotNull(message="\u5f85\u5904\u7406\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5f85\u5904\u7406\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a") CustomerMessageDTO messageDTO) throws WeChatException, ParamCheckException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)messageDTO);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        WeChatResponse weChatResponse = (WeChatResponse)JSON.parseObject((String)body, WeChatResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }

    public List<WeChatResponse> pushCustomer(@NotNull(message="\u5f85\u5904\u7406\u7684\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5f85\u5904\u7406\u7684\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a") List<CustomerMessageDTO> messageList) throws ParamCheckException {
        if (CollectionUtils.isEmpty(messageList)) {
            return new ArrayList<WeChatResponse>();
        }
        ArrayList<WeChatResponse> responseList = new ArrayList<WeChatResponse>();
        CountDownLatch countDownLatch = new CountDownLatch(messageList.size());
        this.batchExecutor.batchExecute(true, messageList, list -> {
            for (CustomerMessageDTO message : list) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                String json = JSON.toJSONString((Object)message);
                HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
                String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
                ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
                String body = (String)responseEntity.getBody();
                WeChatResponse weChatResponse = (WeChatResponse)JSON.parseObject((String)body, WeChatResponse.class);
                responseList.add(weChatResponse);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            return responseList;
        }
        return responseList;
    }
}

