/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import net.jlxxw.wechat.enums.MaterialEnum;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.material.TempMaterialManager;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.material.PermanentMaterialResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class PermanentMaterialManager {
    private static final Logger logger = LoggerFactory.getLogger(TempMaterialManager.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    public PermanentMaterialResponse upload(@NotNull(message="\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") MaterialEnum materialEnum, @NotNull(message="\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") File file, String videoTitle, String videoIntroduction) throws WeChatException, ParamCheckException {
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        if (materialEnum.equals((Object)MaterialEnum.VIDEO)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("title", (Object)videoTitle);
            jsonObject.put("introduction", (Object)videoIntroduction);
            param.add((Object)"description", (Object)JSON.toJSONString((Object)jsonObject));
        }
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/add_material?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750url:{}", url);
        HttpEntity httpEntity = new HttpEntity((Object)param);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        String result = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", result);
        PermanentMaterialResponse response = (PermanentMaterialResponse)JSON.parseObject((String)result, PermanentMaterialResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(result);
        }
        return response;
    }

    public PermanentMaterialResponse upload(@NotNull(message="\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") MaterialEnum materialEnum, final @NotNull(message="\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a") byte[] fileData, final @NotBlank(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String fileName, String videoTitle, String videoIntroduction) throws WeChatException, ParamCheckException {
        AbstractResource resource = new AbstractResource(){

            public String getDescription() {
                return null;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(fileData);
            }

            public String getFilename() {
                return fileName;
            }
        };
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        if (materialEnum.equals((Object)MaterialEnum.VIDEO)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("title", (Object)videoTitle);
            jsonObject.put("introduction", (Object)videoIntroduction);
            param.add((Object)"description", (Object)JSON.toJSONString((Object)jsonObject));
        }
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/add_material?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750url:{}", url);
        HttpEntity httpEntity = new HttpEntity((Object)param);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        String result = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", result);
        PermanentMaterialResponse response = (PermanentMaterialResponse)JSON.parseObject((String)result, PermanentMaterialResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(result);
        }
        return response;
    }

    public byte[] download(@NotBlank(message="\u4e0b\u8f7d\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e0b\u8f7d\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a") String mediaId) throws WeChatException, ParamCheckException {
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/get_material?access_token={0}", tokenFromLocal);
        LoggerUtils.debug(logger, "\u4e0b\u8f7d\u6c38\u4e45\u7d20\u6750url:{}", url);
        HttpHeaders headers = new HttpHeaders();
        JSONObject media = new JSONObject();
        media.put("media_id", (Object)mediaId);
        HttpEntity requestEntity = new HttpEntity((Object)media.toJSONString(), (MultiValueMap)headers);
        ResponseEntity entity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, byte[].class, new Object[0]);
        byte[] body = (byte[])entity.getBody();
        HttpHeaders httpHeaders = entity.getHeaders();
        MediaType contentType = httpHeaders.getContentType();
        if (MediaType.APPLICATION_JSON.equalsTypeAndSubtype((MimeType)contentType)) {
            String json = new String(body, StandardCharsets.UTF_8);
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            WeChatResponse weChatResponse = (WeChatResponse)JSON.toJavaObject((JSON)jsonObject, WeChatResponse.class);
            if (!weChatResponse.isSuccessful()) {
                throw new WeChatException(weChatResponse);
            }
            String videoUrl = jsonObject.getString("down_url");
            ResponseEntity videoResponse = this.restTemplate.exchange(videoUrl, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
            return (byte[])videoResponse.getBody();
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)new String(body, StandardCharsets.UTF_8));
            WeChatResponse weChatResponse = (WeChatResponse)jsonObject.toJavaObject(WeChatResponse.class);
            throw new WeChatException(weChatResponse);
        }
        catch (JSONException jSONException) {
            return body;
        }
    }

    public WeChatResponse deleteMaterial(@NotBlank(message="\u5220\u9664\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5220\u9664\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a") String mediaId) throws WeChatException, ParamCheckException {
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/del_material?access_token={0}", tokenFromLocal);
        LoggerUtils.debug(logger, "\u5220\u9664\u6c38\u4e45\u7d20\u6750url:{}", url);
        HttpHeaders headers = new HttpHeaders();
        JSONObject media = new JSONObject();
        media.put("media_id", (Object)mediaId);
        HttpEntity requestEntity = new HttpEntity((Object)media.toJSONString(), (MultiValueMap)headers);
        ResponseEntity entity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        String body = (String)entity.getBody();
        LoggerUtils.debug(logger, "\u5220\u9664\u6c38\u4e45\u7d20\u6750:{},\u8fd4\u56de\u503c:", mediaId, body);
        WeChatResponse weChatResponse = (WeChatResponse)JSON.parseObject((String)body, WeChatResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }
}

