/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.material;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.material.MaterialCountResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"weChatTokenManager"})
@Component
public class MaterialManager {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    public MaterialCountResponse materialCount() throws WeChatException {
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token={0}", tokenFromLocal);
        ResponseEntity response = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String json = (String)response.getBody();
        MaterialCountResponse body = (MaterialCountResponse)JSON.toJavaObject((JSON)JSON.parseObject((String)json), MaterialCountResponse.class);
        if (!body.isSuccessful()) {
            throw new WeChatException(body);
        }
        return body;
    }
}

