/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.auth;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import net.jlxxw.wechat.dto.auth.AuthScope;
import net.jlxxw.wechat.enums.LanguageEnum;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.auth.AuthAccessTokenResponse;
import net.jlxxw.wechat.response.auth.AuthUserInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class WebPageAuthorizationManager {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeChatProperties weChatProperties;

    public String getAuthorizeUrl(@NotBlank(message="\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="/(http:\\/\\/|https:\\/\\/)((\\w|=|\\?|\\.|\\/|&|-)+)/g", message="\u91cd\u5b9a\u5411\u5730\u5740\u5fc5\u987b\u662f\u4e00\u4e2a\u94fe\u63a5\u5730\u5740") @NotBlank(message="\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="/(http:\\/\\/|https:\\/\\/)((\\w|=|\\?|\\.|\\/|&|-)+)/g", message="\u91cd\u5b9a\u5411\u5730\u5740\u5fc5\u987b\u662f\u4e00\u4e2a\u94fe\u63a5\u5730\u5740") String redirectUri, @NotNull(message="\u6388\u6743\u4f5c\u7528\u57df\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6388\u6743\u4f5c\u7528\u57df\u4e0d\u80fd\u4e3a\u7a7a") AuthScope scope, @Size(max=128, message="\u6700\u5927\u957f\u5ea6128\u5b57\u8282") @Size(max=128, message="\u6700\u5927\u957f\u5ea6128\u5b57\u8282") String state) throws ParamCheckException, UnsupportedEncodingException {
        String encode = URLEncoder.encode(redirectUri, StandardCharsets.UTF_8.toString());
        return MessageFormat.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid={0}&redirect_uri={1}&response_type=code&scope={2}&state={3}#wechat_redirect", this.weChatProperties.getAppId(), encode, scope.getCode(), state);
    }

    public AuthAccessTokenResponse getAuthorizeAccessToken(@NotBlank(message="\u5fae\u4fe1\u6388\u6743code\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5fae\u4fe1\u6388\u6743code\u4e0d\u80fd\u4e3a\u7a7a") String code) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid={0}&secret={1}&code={2}&grant_type=authorization_code", this.weChatProperties.getAppId(), this.weChatProperties.getSecret(), code);
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)entity.getBody();
        AuthAccessTokenResponse response = (AuthAccessTokenResponse)JSONObject.parseObject((String)body, AuthAccessTokenResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public AuthAccessTokenResponse refreshToken(@NotBlank(message="\u5f85\u5237\u65b0\u5f85token\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5f85\u5237\u65b0\u5f85token\u4e0d\u80fd\u4e3a\u7a7a") String token) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/sns/oauth2/refresh_token?appid={0}&grant_type=refresh_token&refresh_token={1}", this.weChatProperties.getAppId(), token);
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)entity.getBody();
        AuthAccessTokenResponse response = (AuthAccessTokenResponse)JSONObject.parseObject((String)body, AuthAccessTokenResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public AuthUserInfoResponse getUserInfo(@NotBlank(message="\u7528\u6237\u7684id\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237\u7684id\u4e0d\u80fd\u4e3a\u7a7a") String openId, @NotBlank(message="\u6388\u6743token\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6388\u6743token\u4e0d\u80fd\u4e3a\u7a7a") String accessToken, @NotNull(message="\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a") LanguageEnum languageEnum) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/sns/userinfo?access_token={0}&openid={1}&lang={2}", accessToken, openId, languageEnum.getCode());
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)entity.getBody();
        AuthUserInfoResponse response = (AuthUserInfoResponse)JSONObject.parseObject((String)body, AuthUserInfoResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }

    public WeChatResponse checkAccessToken(@NotBlank(message="\u7528\u6237\u7684id\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237\u7684id\u4e0d\u80fd\u4e3a\u7a7a") String openId, @NotBlank(message="\u6388\u6743token\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6388\u6743token\u4e0d\u80fd\u4e3a\u7a7a") String accessToken) throws WeChatException, ParamCheckException {
        String url = MessageFormat.format("https://api.weixin.qq.com/sns/auth?access_token={0}&openid={1}", accessToken, openId);
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        String body = (String)entity.getBody();
        WeChatResponse response = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!response.isSuccessful()) {
            throw new WeChatException(response);
        }
        return response;
    }
}

