/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.api;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import javax.validation.constraints.NotBlank;
import net.jlxxw.wechat.exception.ParamCheckException;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.api.ApiRequestRecord;
import net.jlxxw.wechat.response.api.ApiResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lazy
@DependsOn(value={"weChatProperties", "weChatTokenManager"})
@Component
public class OpenApiManager {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiManager.class);
    @Autowired
    private WeChatProperties weChatProperties;
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private RestTemplate restTemplate;

    public WeChatResponse clean() throws WeChatException {
        String appId = this.weChatProperties.getAppId();
        String token = this.weChatTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/clear_quota?access_token={0}", token);
        String json = jsonObject.toJSONString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u6e05\u7a7a\u6bcf\u65e5\u8c03\u7528\u63a5\u53e3\u6b21\u6570\u8fd4\u56de\u7ed3\u679c:{}", body);
        WeChatResponse weChatResponse = (WeChatResponse)JSONObject.parseObject((String)body, WeChatResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }

    public ApiResponse selectQuota(@NotBlank(message="cgiPath\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="cgiPath\u4e0d\u80fd\u4e3a\u7a7a") String cgiPath) throws WeChatException, ParamCheckException {
        String token = this.weChatTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cgi_path", (Object)cgiPath);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/quota/get?access_token={0}", token);
        String json = jsonObject.toJSONString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u67e5\u8be2\u6bcf\u65e5\u8c03\u7528\u63a5\u53e3\u6b21\u6570\u8fd4\u56de\u7ed3\u679c:{}", body);
        ApiResponse weChatResponse = (ApiResponse)JSONObject.parseObject((String)body, ApiResponse.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }

    public ApiRequestRecord selectRid(@NotBlank(message="rid\u4e0d\u53ef\u4ee5\u4e3a\u7a7a") @NotBlank(message="rid\u4e0d\u53ef\u4ee5\u4e3a\u7a7a") String rid) throws WeChatException, ParamCheckException {
        String token = this.weChatTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("rid", (Object)rid);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/rid/get?access_token={0}", token);
        String json = jsonObject.toJSONString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        LoggerUtils.debug(logger, "\u67e5\u8be2rid:{},\u8fd4\u56de\u7ed3\u679c:{}", rid, body);
        ApiRequestRecord weChatResponse = (ApiRequestRecord)JSONObject.parseObject((String)body, ApiRequestRecord.class);
        if (!weChatResponse.isSuccessful()) {
            throw new WeChatException(weChatResponse);
        }
        return weChatResponse;
    }
}

