/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.controller;

import java.io.PrintWriter;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jlxxw.wechat.component.EventBus;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.security.WeChatServerSecurityCheck;
import net.jlxxw.wechat.util.LoggerUtils;
import net.jlxxw.wechat.util.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@ConditionalOnProperty(value={"we-chat.netty.server.enable-netty"}, havingValue="false")
public class WeChatMessageController {
    private static final Logger logger = LoggerFactory.getLogger(WeChatMessageController.class);
    @Autowired
    private EventBus eventBus;
    @Autowired(required=false)
    private WeChatServerSecurityCheck weChatServerSecurityCheck;
    @Autowired
    private WeChatProperties weChatProperties;

    @PostConstruct
    private void postConstruct() {
        LoggerUtils.info(logger, "\u5df2\u7981\u7528netty\u670d\u52a1\uff0c\u5e76\u542f\u7528web\u63a7\u5236\u5668", new Object[0]);
    }

    @RequestMapping(value={"weChat"})
    public void coreController(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ipAddress;
        if (this.weChatProperties.isEnableWeChatCallBackServerSecurityCheck() && this.weChatServerSecurityCheck != null && !this.weChatServerSecurityCheck.isSecurity(ipAddress = NetworkUtil.getIpAddress(request))) {
            LoggerUtils.warn(logger, "\u53d1\u73b0\u975e\u6cd5ip\u8bbf\u95ee:{}", ipAddress);
            return;
        }
        String result = this.eventBus.dispatcher(request);
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
        writer.close();
    }
}

