/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.controller;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.util.LoggerUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class WeChatDevelopmentCertification {
    private static final Logger logger = LoggerFactory.getLogger(WeChatDevelopmentCertification.class);
    @Autowired
    private WeChatProperties weChatProperties;

    @GetMapping(value={"verifyToken"})
    public String verifyToken(HttpServletRequest request) throws NoSuchAlgorithmException {
        String msgSignature = request.getParameter("signature");
        String msgTimestamp = request.getParameter("timestamp");
        String msgNonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        LoggerUtils.info(logger, "\u63a5\u6536\u5230\u5fae\u4fe1\u8bf7\u6c42\uff1asignature={},timestamp={},nonce={},echostr={}", msgSignature, msgTimestamp, msgNonce, echostr);
        if (this.verify(msgSignature, msgTimestamp, msgNonce)) {
            LoggerUtils.info(logger, "\u9a8c\u8bc1\u901a\u8fc7", new Object[0]);
            return echostr;
        }
        LoggerUtils.info(logger, "\u9a8c\u8bc1\u5931\u8d25", new Object[0]);
        return null;
    }

    private boolean verify(String msgSignature, String timeStamp, String nonce) throws NoSuchAlgorithmException {
        String signature = WeChatDevelopmentCertification.sha1Sign(this.weChatProperties.getVerifyToken(), timeStamp, nonce);
        if (!signature.equals(msgSignature)) {
            throw new RuntimeException("token\u8ba4\u8bc1\u5931\u8d25");
        }
        return true;
    }

    private static String sha1Sign(String token, String timestamp, String nonce) throws NoSuchAlgorithmException {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("verify-token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object[] array = new String[]{token, timestamp, nonce};
        StringBuffer sb = new StringBuffer();
        Arrays.sort(array);
        for (int i = 0; i < 3; ++i) {
            sb.append((String)array[i]);
        }
        String str = sb.toString();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(str.getBytes());
        byte[] digest = md.digest();
        StringBuffer hexstr = new StringBuffer();
        String shaHex = "";
        for (int i = 0; i < digest.length; ++i) {
            shaHex = Integer.toHexString(digest[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(shaHex);
        }
        return hexstr.toString();
    }
}

