/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BatchExecutor {
    private static final long DEFAULT_LIMIT = 500L;
    @Autowired
    @Qualifier(value="batchExecuteThreadPool")
    private ThreadPoolTaskExecutor batchExecuteThreadPool;

    private <T> void batchExecute(List<T> data, Consumer<List<T>> consumer) {
        this.execute(false, data, consumer, 500L);
    }

    public <T> void batchExecute(boolean useThreadPool, List<T> data, Consumer<List<T>> consumer) {
        this.execute(useThreadPool, data, consumer, 500L);
    }

    public <T> void execute(boolean useThreadPool, List<T> data, Consumer<List<T>> consumer, long limit) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        if (limit <= 0L) {
            throw new IllegalArgumentException("limit \u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0 ");
        }
        if (Objects.isNull(consumer)) {
            throw new IllegalArgumentException("consumer \u4e0d\u5e94\u4e3anull");
        }
        long endIndex = data.size() - 1;
        long startIndex = 0L;
        do {
            List collect = data.stream().skip(startIndex).limit(limit).collect(Collectors.toList());
            if (useThreadPool) {
                this.batchExecuteThreadPool.execute(() -> consumer.accept(collect));
                continue;
            }
            consumer.accept(collect);
        } while ((startIndex += limit) <= endIndex);
    }
}

