/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import net.jlxxw.wechat.exception.ParamCheckException;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorDescriptor;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorFactoryImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;

@Aspect
@Component
@Order(value=-1)
public class ParamCheckAOP {
    private static final ConstraintHelper constraintHelper = ConstraintHelper.forAllBuiltinConstraints();
    private static final ConstraintValidatorFactory factory = new ConstraintValidatorFactoryImpl();
    private Map<Class<? extends Annotation>, List<? extends ConstraintValidatorDescriptor<?>>> enabledBuiltinConstraints = new HashMap();

    @PostConstruct
    private void init() {
        Field field = ReflectionUtils.findField(ConstraintHelper.class, (String)"enabledBuiltinConstraints");
        try {
            field.setAccessible(true);
            this.enabledBuiltinConstraints = (Map)field.get(constraintHelper);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Pointcut(value="@within(org.springframework.cloud.openfeign.FeignClient) || execution(public * net.jlxxw.wechat.function.*.*.*(..))")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void validation(JoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        Method declaredMethod = joinPoint.getTarget().getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
        Annotation[][] parameterAnnotations = declaredMethod.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Object param = args[i];
            int length = parameterAnnotations[i].length;
            List<Object> validatedSet = new LinkedList();
            HashSet<String> validResult = new HashSet<String>();
            for (int j = 0; j < length; ++j) {
                Annotation annotation = parameterAnnotations[i][j];
                if (annotation instanceof Validated) {
                    if (Objects.isNull(param)) {
                        throw new ParamCheckException("\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    Validated validated = (Validated)annotation;
                    Class[] classList = validated.value();
                    validResult.addAll(this.valid(param, classList));
                    validatedSet = Arrays.asList(classList);
                } else {
                    try {
                        List descriptors;
                        Class<? extends Annotation> annotationType = annotation.annotationType();
                        if (!this.enabledBuiltinConstraints.containsKey(annotationType)) continue;
                        Field groups = ReflectionUtils.findField(annotationType, (String)"groups");
                        if (Objects.nonNull(groups)) {
                            groups.setAccessible(true);
                            Class[] groupArray = (Class[])groups.get(annotation);
                            if (groupArray != null && !CollectionUtils.containsAny(validatedSet, Arrays.asList(groupArray))) continue;
                        }
                        if (!CollectionUtils.isEmpty((Collection)(descriptors = constraintHelper.getAllValidatorDescriptors(annotationType)))) {
                            for (ConstraintValidatorDescriptor descriptor : descriptors) {
                                ConstraintValidator validator = descriptor.newInstance(factory);
                                validator.initialize(annotation);
                                boolean valid = validator.isValid(param, null);
                                if (valid) continue;
                                Method message = ReflectionUtils.findMethod(annotationType, (String)"message");
                                String invoke = (String)message.invoke((Object)annotation, new Object[0]);
                                validResult.add(invoke);
                            }
                        }
                    }
                    catch (Exception annotationType) {
                        // empty catch block
                    }
                }
                if (CollectionUtils.isEmpty(validResult)) continue;
                String message = String.join((CharSequence)"\n", validResult);
                throw new ParamCheckException(message);
            }
        }
    }

    private Set<String> valid(Object obj, Class[] clazz) {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        Set validate = validator.validate(obj, clazz);
        HashSet<String> set = new HashSet<String>();
        validate.forEach(o -> {
            String message = o.getMessage();
            if (StringUtils.isNotBlank((CharSequence)message)) {
                set.add(message);
            }
        });
        return set;
    }
}

