/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import net.jlxxw.wechat.context.SpringContextHolder;
import net.jlxxw.wechat.security.WeChatSecurityIpStore;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;

public class WeChatServerSecurityCheck {
    private static final Logger logger = LoggerFactory.getLogger(WeChatServerSecurityCheck.class);
    private WeChatSecurityIpStore weChatSecurityIpStore = null;
    @Autowired
    private SpringContextHolder springContextHolder;

    @PostConstruct
    private void init() {
        try {
            this.weChatSecurityIpStore = this.springContextHolder.getBean(WeChatSecurityIpStore.class);
            Class clazz = this.weChatSecurityIpStore.getClass();
            if (AopUtils.isAopProxy((Object)this.weChatSecurityIpStore)) {
                clazz = AopUtils.getTargetClass((Object)this.weChatSecurityIpStore);
            }
            LoggerUtils.info(logger, "\u521d\u59cb\u5316\u5fae\u4fe1\u5b89\u5168ip\u5b58\u50a8\u5668\uff0c\u4f7f\u7528\u5916\u7f6e\u5b58\u50a8,{}", clazz.getName());
        }
        catch (NoSuchBeanDefinitionException e) {
            LoggerUtils.info(logger, "\u521d\u59cb\u5316\u5fae\u4fe1\u5b89\u5168ip\u5b58\u50a8\u5668\uff0c\u4f7f\u7528\u5185\u7f6e\u5b58\u50a8", new Object[0]);
            this.weChatSecurityIpStore = new WeChatSecurityIpStore(){
                private final Set<String> ipWhitelist = new HashSet<String>();

                @Override
                public void addSecurityIp(String ip) {
                    this.ipWhitelist.add(ip);
                }

                @Override
                public boolean isSecurityIp(String ip) {
                    return this.ipWhitelist.contains(ip);
                }

                @Override
                public void addSecurityIp(List<String> ipList) {
                    this.ipWhitelist.addAll(ipList);
                }
            };
        }
    }

    public boolean isSecurity(String requestIp) {
        return this.weChatSecurityIpStore.isSecurityIp(requestIp);
    }

    public void updateWeiXinServerIp(List<String> ipList) {
        logger.info("\u66f4\u65b0ip\u767d\u540d\u5355\uff1a{}", ipList);
        this.weChatSecurityIpStore.addSecurityIp(ipList);
    }
}

