/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.response;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Arrays;
import java.util.List;

@JacksonXmlRootElement(localName="xml")
public class WeChatMessageResponse {
    @JacksonXmlProperty
    private String toUserName;
    @JacksonXmlProperty
    private String fromUserName;
    private Long createTime;
    @JacksonXmlProperty
    private String msgType;
    @JacksonXmlProperty
    private String content;
    private Integer articleCount;
    @JacksonXmlProperty(localName="Articles")
    private List<Article> articles;
    private Image image;
    private Music music;
    private Video video;
    private Voice voice;
    private TransInfo transInfo;

    public String getToUserName() {
        return this.toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getArticleCount() {
        return this.articleCount;
    }

    public void setArticleCount(Integer articleCount) {
        this.articleCount = articleCount;
    }

    public List<Article> getArticles() {
        return this.articles;
    }

    public void setArticles(List<Article> articles) {
        this.articles = articles;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Music getMusic() {
        return this.music;
    }

    public void setMusic(Music music) {
        this.music = music;
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    public TransInfo getTransInfo() {
        return this.transInfo;
    }

    public void setTransInfo(TransInfo transInfo) {
        this.transInfo = transInfo;
    }

    public static WeChatMessageResponse buildText(String content) {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("text");
        weChatMessageResponse.setContent(content);
        return weChatMessageResponse;
    }

    public static WeChatMessageResponse buildImage(String mediaId) {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("image");
        Image image = new Image();
        image.setMediaId(mediaId);
        weChatMessageResponse.setImage(image);
        return weChatMessageResponse;
    }

    public static WeChatMessageResponse buildVoice(String mediaId) {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("voice");
        Voice voice = new Voice();
        voice.setMediaId(mediaId);
        weChatMessageResponse.setVoice(voice);
        return weChatMessageResponse;
    }

    public static WeChatMessageResponse buildVideo(String mediaId, String title, String description) {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("video");
        Video video = new Video();
        video.setMediaId(mediaId);
        video.setTitle(title);
        video.setDescription(description);
        weChatMessageResponse.setVideo(video);
        return weChatMessageResponse;
    }

    public static WeChatMessageResponse buildMusic(String title, String description, String musicUrl, String hqMusicUrl, String thumbMediaId) {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("music");
        Music music = new Music();
        music.setTitle(title);
        music.setDescription(description);
        music.setMusicUrl(musicUrl);
        music.setHqMusicUrl(hqMusicUrl);
        music.setThumbMediaId(thumbMediaId);
        weChatMessageResponse.setMusic(music);
        return weChatMessageResponse;
    }

    public static WeChatMessageResponse buildArticle(Article ... articles) {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("news");
        weChatMessageResponse.setArticleCount(articles.length);
        weChatMessageResponse.setArticles(Arrays.asList(articles));
        return weChatMessageResponse;
    }

    public static WeChatMessageResponse buildTransferCustomerService() {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("transfer_customer_service");
        return weChatMessageResponse;
    }

    public static WeChatMessageResponse buildTransferCustomerService(String kfAccount) {
        WeChatMessageResponse weChatMessageResponse = new WeChatMessageResponse();
        weChatMessageResponse.setMsgType("transfer_customer_service");
        TransInfo transInfo = new TransInfo();
        transInfo.setKfAccount(kfAccount);
        weChatMessageResponse.setTransInfo(transInfo);
        return weChatMessageResponse;
    }

    public static class TransInfo {
        private String kfAccount;

        public String getKfAccount() {
            return this.kfAccount;
        }

        public void setKfAccount(String kfAccount) {
            this.kfAccount = kfAccount;
        }
    }

    public static class Article {
        @JacksonXmlProperty
        private String title;
        @JacksonXmlProperty
        private String description;
        @JacksonXmlProperty
        private String picUrl;
        @JacksonXmlProperty
        private String url;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getPicUrl() {
            return this.picUrl;
        }

        public void setPicUrl(String picUrl) {
            this.picUrl = picUrl;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class Music {
        @JacksonXmlProperty
        private String title;
        @JacksonXmlProperty
        private String description;
        @JacksonXmlProperty(localName="MusicUrl")
        private String musicUrl;
        @JacksonXmlProperty(localName="HQMusicUrl")
        private String hqMusicUrl;
        @JacksonXmlProperty
        private String thumbMediaId;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getMusicUrl() {
            return this.musicUrl;
        }

        public void setMusicUrl(String musicUrl) {
            this.musicUrl = musicUrl;
        }

        public String getHqMusicUrl() {
            return this.hqMusicUrl;
        }

        public void setHqMusicUrl(String hqMusicUrl) {
            this.hqMusicUrl = hqMusicUrl;
        }

        public String getThumbMediaId() {
            return this.thumbMediaId;
        }

        public void setThumbMediaId(String thumbMediaId) {
            this.thumbMediaId = thumbMediaId;
        }
    }

    public static class Video {
        @JacksonXmlProperty
        private String mediaId;
        @JacksonXmlProperty
        private String title;
        @JacksonXmlProperty
        private String description;

        public String getMediaId() {
            return this.mediaId;
        }

        public void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class Voice {
        @JacksonXmlProperty
        private String mediaId;

        public String getMediaId() {
            return this.mediaId;
        }

        public void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }
    }

    public static class Image {
        @JacksonXmlProperty
        private String mediaId;

        public String getMediaId() {
            return this.mediaId;
        }

        public void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }
    }
}

