/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jlxxw.wechat.enums.LanguageEnum;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.function.user.UserManager;
import net.jlxxw.wechat.response.user.SubscriptionResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lazy
@DependsOn(value={"weChatProperties", "weChatTokenManager", "webClientUtils"})
@Component
public class UserManagerImpl
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger(UserManagerImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    @Override
    public Set<String> findAll() {
        JSONObject resultData;
        HashSet<String> openIdSet = new HashSet<String>();
        String token = this.weChatTokenManager.getTokenFromLocal();
        int totle = 1;
        String nextOpenId = "";
        for (int current = 0; current < totle; current += resultData.getInteger("count").intValue()) {
            String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/user/get?access_token={0}&next_openid={1}", token, nextOpenId);
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
            String body = (String)forEntity.getBody();
            resultData = JSONObject.parseObject((String)body);
            if (resultData.getInteger("errcode") == null || resultData.getInteger("errcode") == 0) {
                totle = resultData.getInteger("total");
                nextOpenId = resultData.getString("next_openid");
                JSONArray array = resultData.getJSONArray("openid");
                if (CollectionUtils.isEmpty((Collection)array)) continue;
                array.forEach(o -> openIdSet.add(o.toString()));
                continue;
            }
            WeChatException weChatException = new WeChatException("\u83b7\u53d6\u5168\u90e8openId\u5931\u8d25\uff0c\u5fae\u4fe1\u8fd4\u56de\u503c:" + resultData.toJSONString());
            weChatException.setErrorCode(resultData.getInteger("errcode"));
            throw weChatException;
        }
        return openIdSet;
    }

    @Override
    public List<SubscriptionResponse> findUserInfo(List<String> openIdList, LanguageEnum languageEnum) {
        ArrayList<SubscriptionResponse> result = new ArrayList<SubscriptionResponse>();
        if (CollectionUtils.isEmpty(openIdList)) {
            return result;
        }
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=" + token;
        int size = 100;
        int countFor = this.countFor(openIdList.size());
        int start = 0;
        int end = 0;
        for (int i = 0; i < countFor; ++i) {
            start = i * size;
            end = Math.min((i + 1) * size, openIdList.size());
            List<String> tempList = openIdList.subList(start, end);
            JSONObject requestParam = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (String openId : tempList) {
                JSONObject param = new JSONObject();
                param.put("openid", (Object)openId);
                param.put("lang", (Object)languageEnum.getCode());
                jsonArray.add((Object)param);
            }
            requestParam.put("user_list", (Object)jsonArray);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String json = JSON.toJSONString((Object)requestParam);
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            JSONObject resultData = JSONObject.parseObject((String)((String)responseEntity.getBody()));
            if (resultData.getInteger("errcode") != null && resultData.getInteger("errcode") != 0) {
                WeChatException weChatException = new WeChatException("\u6279\u91cf\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5fae\u4fe1\u8fd4\u56de\u503c:" + resultData.toJSONString() + ",\u7528\u6237openId\u5217\u8868:" + JSON.toJSONString(tempList));
                weChatException.setErrorCode(resultData.getInteger("errcode"));
                throw weChatException;
            }
            JSONArray infoList = resultData.getJSONArray("user_info_list");
            List subscriptionUsers = JSONArray.parseArray((String)JSON.toJSONString((Object)infoList), SubscriptionResponse.class);
            result.addAll(subscriptionUsers);
            logger.info("\u7528\u6237\u6570\u91cf\u603b\u8ba1:{},\u5f53\u524d\u6267\u884c\u6570\u91cf:{}", (Object)openIdList.size(), (Object)end);
        }
        return result;
    }

    @Override
    public SubscriptionResponse getUserInfo(String openId, LanguageEnum languageEnum) {
        if (StringUtils.isBlank((CharSequence)openId)) {
            return null;
        }
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token={0}&openid={1}&lang={2}", token, openId, languageEnum.getCode());
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)forEntity.getBody();
        if (body.getInteger("errcode") == null || body.getInteger("errcode") == 0) {
            return (SubscriptionResponse)body.toJavaObject(SubscriptionResponse.class);
        }
        WeChatException weChatException = new WeChatException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5fae\u4fe1\u8fd4\u56de\u503c:" + body.toJSONString() + ",\u7528\u6237openId:" + openId);
        weChatException.setErrorCode(body.getInteger("errcode"));
        throw weChatException;
    }

    private int countFor(int size) {
        int i = 100;
        if (size % i == 0) {
            return size / i;
        }
        return size / i + 1;
    }
}

