/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.token;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.PostConstruct;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.mapper.TokenMapper;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.response.token.WeChatTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"tokenMapper", "weChatProperties"})
@ConditionalOnProperty(prefix="we-chat", value={"enable-default-token-manager"}, havingValue="true")
@Component(value="weChatTokenManager")
public class DefaultWeChatTokenManagerImpl
implements WeChatTokenManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWeChatTokenManagerImpl.class);
    @Autowired
    private WeChatProperties weChatProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TokenMapper tokenMapper;

    @PostConstruct
    public void postConstruct() {
        this.tokenMapper.createTokenTable();
        this.tokenMapper.createJsApiTicketTable();
    }

    @Override
    public void saveToken(String token) {
        this.tokenMapper.insertToken(token);
    }

    @Override
    public String getTokenFromWeiXin() throws WeChatException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={0}&secret={1}", this.weChatProperties.getAppId(), this.weChatProperties.getSecret());
        WeChatTokenResponse response = (WeChatTokenResponse)this.restTemplate.getForObject(url, WeChatTokenResponse.class, new Object[0]);
        if (Objects.nonNull(response.getErrcode()) && 0 != response.getErrcode()) {
            logger.error("\u5fae\u4fe1\u83b7\u53d6token\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)response));
            WeChatException weChatException = new WeChatException(JSON.toJSONString((Object)response));
            weChatException.setErrorCode(response.getErrcode());
            throw weChatException;
        }
        return response.getAccessToken();
    }

    @Override
    public String getTokenFromLocal() {
        return this.tokenMapper.getToken();
    }

    @Override
    public void saveJsApiTicket(String jsApiTicket) {
        this.tokenMapper.insertJsApiTicket(jsApiTicket);
    }

    @Override
    public String getJsApiTicketFromWeiXin() throws WeChatException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={0}&type=jsapi", this.getTokenFromLocal());
        ResponseEntity response = this.restTemplate.getForEntity(url, WeChatTokenResponse.class, new Object[0]);
        WeChatTokenResponse body = (WeChatTokenResponse)response.getBody();
        if (Objects.nonNull(body.getErrcode()) && 0 != body.getErrcode()) {
            logger.error("\u5fae\u4fe1\u83b7\u53d6token\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)response));
            WeChatException weChatException = new WeChatException(JSON.toJSONString((Object)response));
            weChatException.setErrorCode(body.getErrcode());
            throw weChatException;
        }
        return body.getTicket();
    }

    @Override
    public String getJsApiTicketFromLocal() {
        return this.tokenMapper.getJsApiTicket();
    }
}

