/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.qrcode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.qrcode.QrCodeResponse;
import net.jlxxw.wechat.response.qrcode.TempQrCodeResponse;
import net.jlxxw.wechat.util.WebClientUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Lazy
@DependsOn(value={"weChatProperties", "weChatTokenManager", "webClientUtils"})
@Component
public class AsyncQrcodeManager {
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public Mono<TempQrCodeResponse> createTempStringQrcode(String eventKey, Long expireSecond) {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), TempQrCodeResponse.class);
    }

    public Mono<TempQrCodeResponse> createTempIdQrcode(Long id, Long expireSecond) {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), TempQrCodeResponse.class);
    }

    public Mono<QrCodeResponse> createStringQrcode(String eventKey) {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), QrCodeResponse.class);
    }

    public Mono<QrCodeResponse> createIdQrcode(Long id) {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), QrCodeResponse.class);
    }
}

