/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.push;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jlxxw.wechat.component.BatchExecutor;
import net.jlxxw.wechat.dto.template.WeChatTemplateDTO;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lazy
@DependsOn(value={"weChatProperties", "weChatTokenManager", "webClientUtils"})
@Component
public class SyncPushTemplate {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BatchExecutor batchExecutor;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    public WeChatResponse pushTemplate(WeChatTemplateDTO template) {
        Objects.requireNonNull(template);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)template);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, WeChatResponse.class, new Object[0]);
        return (WeChatResponse)responseEntity.getBody();
    }

    public List<WeChatResponse> pushTemplate(List<WeChatTemplateDTO> templateList) {
        if (CollectionUtils.isEmpty(templateList)) {
            return new ArrayList<WeChatResponse>();
        }
        ArrayList<WeChatResponse> responseList = new ArrayList<WeChatResponse>();
        this.batchExecutor.batchExecute(true, templateList, list -> {
            for (WeChatTemplateDTO weChatTemplate : list) {
                WeChatResponse weChatResponse = this.pushTemplate(weChatTemplate);
                responseList.add(weChatResponse);
            }
        });
        return responseList;
    }
}

