/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.push;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jlxxw.wechat.component.BatchExecutor;
import net.jlxxw.wechat.dto.customer.CustomerMessageDTO;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lazy
@DependsOn(value={"weChatProperties", "weChatTokenManager", "webClientUtils"})
@Component
public class SyncPushCustomer {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BatchExecutor batchExecutor;
    @Autowired
    private WeChatTokenManager weChatTokenManager;

    public WeChatResponse pushCustomer(CustomerMessageDTO messageDTO) {
        Objects.requireNonNull(messageDTO);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)messageDTO);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, WeChatResponse.class, new Object[0]);
        return (WeChatResponse)responseEntity.getBody();
    }

    public List<WeChatResponse> pushCustomer(List<CustomerMessageDTO> messageList) {
        if (CollectionUtils.isEmpty(messageList)) {
            return new ArrayList<WeChatResponse>();
        }
        ArrayList<WeChatResponse> responseList = new ArrayList<WeChatResponse>();
        this.batchExecutor.batchExecute(true, messageList, list -> {
            for (CustomerMessageDTO message : list) {
                WeChatResponse weChatResponse = this.pushCustomer(message);
                responseList.add(weChatResponse);
            }
        });
        return responseList;
    }
}

