/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.function.Consumer;
import net.jlxxw.wechat.enums.MaterialEnum;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.material.TempMaterialResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import net.jlxxw.wechat.util.WebClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class AsyncTempMaterialManager {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTempMaterialManager.class);
    @Autowired
    private WebClient webClient;
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public Mono<TempMaterialResponse> upload(MaterialEnum materialEnum, File file) {
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/media/upload?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750url:{}", url);
        Mono<JSONObject> mono = this.webClientUtils.sendPostFormUrlEncoded(url, (MultiValueMap<String, Object>)param, JSONObject.class);
        return mono.map(obj -> {
            if (obj.getInteger("errcode") != null) {
                WeChatException weChatException = new WeChatException(JSON.toJSONString((Object)obj));
                weChatException.setErrorCode(obj.getInteger("errcode"));
                throw weChatException;
            }
            LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", JSON.toJSONString((Object)obj));
            TempMaterialResponse materialVO = new TempMaterialResponse();
            materialVO.setMediaId(obj.getString("media_id"));
            materialVO.setCreatedAt(obj.getLong("created_at"));
            materialVO.setType(obj.getString("type"));
            return materialVO;
        });
    }

    public Mono<TempMaterialResponse> upload(MaterialEnum materialEnum, URI uri, Consumer<TempMaterialResponse> callbackMethod) {
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(Paths.get(uri));
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/media/upload?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750url:{}", url);
        Mono<JSONObject> mono = this.webClientUtils.sendPostFormUrlEncoded(url, (MultiValueMap<String, Object>)param, JSONObject.class);
        return mono.map(obj -> {
            if (obj.getInteger("errcode") != null) {
                WeChatException weChatException = new WeChatException(JSON.toJSONString((Object)obj));
                weChatException.setErrorCode(obj.getInteger("errcode"));
                throw weChatException;
            }
            LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", JSON.toJSONString((Object)obj));
            TempMaterialResponse materialVO = new TempMaterialResponse();
            materialVO.setMediaId(obj.getString("media_id"));
            materialVO.setCreatedAt(obj.getLong("created_at"));
            materialVO.setType(obj.getString("type"));
            return materialVO;
        });
    }

    public Mono<Resource> download(String mediaId, MediaType mediaType) {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/media/get/jssdk?access_token={0}&media_id={1}", token, mediaId);
        LoggerUtils.debug(logger, "\u4e0b\u8f7d\u4e34\u65f6\u7d20\u6750,\u4e0d\u542b\u89c6\u9891url:{}", url);
        return this.webClientUtils.sendGet(url, Resource.class, mediaType);
    }

    public Mono<String> downloadVideo(String mediaId) {
        String token = this.weChatTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/media/get/jssdk?access_token={0}&media_id={1}", token, mediaId);
        LoggerUtils.debug(logger, "\u4e0b\u8f7d\u4e34\u65f6\u89c6\u9891\u7d20\u6750url:{}", url);
        Mono<JSONObject> mono = this.webClientUtils.sendGet(url, JSONObject.class, MediaType.APPLICATION_JSON);
        return mono.map(obj -> {
            String videoUrl = obj.getString("video_url");
            LoggerUtils.debug(logger, "\u4e0b\u8f7d\u89c6\u9891\u4e34\u65f6\u7d20\u6750\u5fae\u4fe1\u51fa\u73b0\u5f02\u5e38\uff0cmediaId:{},\u8fd4\u56de:{}", mediaId, JSON.toJSONString((Object)obj));
            return videoUrl;
        });
    }
}

