/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.text.MessageFormat;
import net.jlxxw.wechat.enums.MaterialEnum;
import net.jlxxw.wechat.exception.WeChatException;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.material.PermanentMaterialResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import net.jlxxw.wechat.util.WebClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

@DependsOn(value={"weChatProperties", "weChatTokenManager", "webClientUtils"})
@Component
public class AsyncPermanentMaterialManager {
    private static final Logger logger = LoggerFactory.getLogger(AsyncPermanentMaterialManager.class);
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public Mono<PermanentMaterialResponse> upload(MaterialEnum materialEnum, File file) {
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/material/add_material?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750url:{}", url);
        return this.postRequest((MultiValueMap<String, Object>)param, url);
    }

    public Mono<PermanentMaterialResponse> upload(MaterialEnum materialEnum, URI uri) {
        String tokenFromLocal = this.weChatTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(Paths.get(uri));
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/material/add_material?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750url:{}", url);
        return this.postRequest((MultiValueMap<String, Object>)param, url);
    }

    public Mono<Resource> download(String mediaId) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"mediaId", (Object)mediaId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/get_material?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u4e0b\u8f7d\u6c38\u4e45\u7d20\u6750url:{}", url);
        return this.webClientUtils.sendPostFormUrlEncoded(url, (MultiValueMap<String, Object>)param, Resource.class);
    }

    public Mono<WeChatResponse> delete(String mediaId) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"mediaId", (Object)mediaId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/del_material?access_token={0}", this.weChatTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u5220\u9664\u6c38\u4e45\u7d20\u6750url:{}", url);
        Mono<JSONObject> mono = this.webClientUtils.sendPostFormUrlEncoded(url, (MultiValueMap<String, Object>)param, JSONObject.class);
        return mono.map(obj -> {
            if (obj.getInteger("errcode") != 0) {
                WeChatException weChatException = new WeChatException(JSON.toJSONString((Object)obj));
                weChatException.setErrorCode(obj.getInteger("errcode"));
                throw weChatException;
            }
            return (WeChatResponse)obj.toJavaObject(WeChatResponse.class);
        });
    }

    private Mono<PermanentMaterialResponse> postRequest(MultiValueMap<String, Object> param, String url) {
        Mono<JSONObject> mono = this.webClientUtils.sendPostFormUrlEncoded(url, param, JSONObject.class);
        return mono.map(obj -> {
            if (obj.getInteger("errcode") != null) {
                WeChatException weChatException = new WeChatException(JSON.toJSONString((Object)obj));
                weChatException.setErrorCode(obj.getInteger("errcode"));
                throw weChatException;
            }
            LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", JSON.toJSONString((Object)obj));
            PermanentMaterialResponse materialVO = new PermanentMaterialResponse();
            materialVO.setMediaId(obj.getString("media_id"));
            materialVO.setUrl(obj.getString("url"));
            return materialVO;
        });
    }
}

