/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.api;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.response.WeChatResponse;
import net.jlxxw.wechat.response.api.ApiRequestRecord;
import net.jlxxw.wechat.response.api.ApiResponse;
import net.jlxxw.wechat.util.WebClientUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Lazy
@DependsOn(value={"weChatProperties", "weChatTokenManager", "webClientUtils"})
@Component
public class AsyncOpenApiManager {
    @Autowired
    private WeChatProperties weChatProperties;
    @Autowired
    private WeChatTokenManager weChatTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public Mono<WeChatResponse> clean() {
        String appId = this.weChatProperties.getAppId();
        String token = this.weChatTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/clear_quota?access_token={0}", token);
        return this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), WeChatResponse.class);
    }

    public Mono<ApiResponse> selectQuota(String cgiPath) {
        if (StringUtils.isBlank((String)cgiPath)) {
            throw new NullPointerException();
        }
        String appId = this.weChatProperties.getAppId();
        String token = this.weChatTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/quota/get?access_token={0}", token);
        return this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), ApiResponse.class);
    }

    public Mono<ApiRequestRecord> selectRid(String rid) {
        if (StringUtils.isBlank((String)rid)) {
            throw new NullPointerException();
        }
        String appId = this.weChatProperties.getAppId();
        String token = this.weChatTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/quota/get?access_token={0}", token);
        return this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), ApiRequestRecord.class);
    }
}

