/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.controller;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jlxxw.wechat.component.EventBus;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.security.WeChatServerSecurityCheck;
import net.jlxxw.wechat.util.NetworkUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@ConditionalOnProperty(value={"we-chat.netty.server.enable-netty"}, havingValue="false")
public class WeChatMessageController {
    @Autowired
    private EventBus eventBus;
    @Autowired(required=false)
    private WeChatServerSecurityCheck weChatServerSecurityCheck;
    @Autowired
    private WeChatProperties weChatProperties;

    @RequestMapping(value={"weChat"})
    public void coreController(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ipAddress;
        if (this.weChatProperties.isEnableWeChatCallBackServerSecurityCheck() && this.weChatServerSecurityCheck != null && !this.weChatServerSecurityCheck.isSecurity(ipAddress = NetworkUtil.getIpAddress(request))) {
            return;
        }
        String result = this.eventBus.dispatcher(request);
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
        writer.close();
    }
}

