/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.jlxxw.wechat.component.WeChatMsgCodec;
import net.jlxxw.wechat.component.listener.AbstractWeChatEventListener;
import net.jlxxw.wechat.component.listener.AbstractWeChatMessageListener;
import net.jlxxw.wechat.component.listener.UnKnowWeChatEventListener;
import net.jlxxw.wechat.component.listener.UnKnowWeChatMessageListener;
import net.jlxxw.wechat.dto.message.AbstractWeChatMessage;
import net.jlxxw.wechat.dto.message.ImageMessage;
import net.jlxxw.wechat.dto.message.LinkMessage;
import net.jlxxw.wechat.dto.message.LocationMessage;
import net.jlxxw.wechat.dto.message.ShortVideoMessage;
import net.jlxxw.wechat.dto.message.TextMessage;
import net.jlxxw.wechat.dto.message.VideoMessage;
import net.jlxxw.wechat.dto.message.VoiceMessage;
import net.jlxxw.wechat.dto.message.event.ClickMenuGetInfoEventMessage;
import net.jlxxw.wechat.dto.message.event.ClickMenuGotoLinkEventMessage;
import net.jlxxw.wechat.dto.message.event.LocationEventMessage;
import net.jlxxw.wechat.dto.message.event.LocationSelectEventMessage;
import net.jlxxw.wechat.dto.message.event.PicPhotoOrAlbumEventMessage;
import net.jlxxw.wechat.dto.message.event.PicSysphotoEventMessage;
import net.jlxxw.wechat.dto.message.event.PicWeChatEventMessage;
import net.jlxxw.wechat.dto.message.event.ScancodePushEventMessage;
import net.jlxxw.wechat.dto.message.event.ScancodeWaitmsgEventMessage;
import net.jlxxw.wechat.dto.message.event.SubscribeEventMessage;
import net.jlxxw.wechat.dto.message.event.SubscribeQrsceneEventMessage;
import net.jlxxw.wechat.dto.message.event.SubscribeScanEventMessage;
import net.jlxxw.wechat.dto.message.event.TemplateEventMessage;
import net.jlxxw.wechat.dto.message.event.UnSubscribeEventMessage;
import net.jlxxw.wechat.dto.message.event.ViewMiniProgramEventMessage;
import net.jlxxw.wechat.enums.WeChatEventTypeEnum;
import net.jlxxw.wechat.enums.WeChatMessageTypeEnum;
import net.jlxxw.wechat.exception.AesException;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.response.WeChatMessageResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventBus {
    private static final Logger logger = LoggerFactory.getLogger(EventBus.class);
    private static final XmlMapper XML_MAPPER = new XmlMapper();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired(required=false)
    private List<AbstractWeChatMessageListener> abstractWeChatMessageListeners;
    @Autowired(required=false)
    private List<AbstractWeChatEventListener> abstractWeChatEventListeners;
    @Autowired(required=false)
    private WeChatMsgCodec weChatMsgCodec;
    @Autowired
    private WeChatProperties weChatProperties;
    @Autowired(required=false)
    private UnKnowWeChatEventListener unKnowWeChatEventListener;
    @Autowired(required=false)
    private UnKnowWeChatMessageListener unKnowWeChatMessageListener;
    @Autowired
    private ThreadPoolTaskExecutor eventBusThreadPool;
    private final Map<WeChatMessageTypeEnum, AbstractWeChatMessageListener> messageListenerMap = new HashMap<WeChatMessageTypeEnum, AbstractWeChatMessageListener>();
    private final Map<WeChatEventTypeEnum, AbstractWeChatEventListener> eventListenerMap = new HashMap<WeChatEventTypeEnum, AbstractWeChatEventListener>();

    @PostConstruct
    public void postConstruct() {
        WeChatEventTypeEnum[] eventValues;
        WeChatMessageTypeEnum[] values;
        XML_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        XML_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        XML_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        if (!CollectionUtils.isEmpty(this.abstractWeChatMessageListeners)) {
            Map<WeChatMessageTypeEnum, List<AbstractWeChatMessageListener>> map = this.abstractWeChatMessageListeners.stream().collect(Collectors.groupingBy(AbstractWeChatMessageListener::supportMessageType));
            map.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BeanCreationException("\u5fae\u4fe1messageListener\u4e0d\u80fd\u6ce8\u518c\u591a\u6b21");
                }
                this.messageListenerMap.put((WeChatMessageTypeEnum)((Object)k), (AbstractWeChatMessageListener)v.get(0));
            });
        }
        for (WeChatMessageTypeEnum value : values = WeChatMessageTypeEnum.values()) {
            if (this.messageListenerMap.containsKey((Object)value)) continue;
            LoggerUtils.warn(logger, value.getDescription() + "\u6d88\u606f\u5904\u7406\u5668\u672a\u6ce8\u518c!!!", new Object[0]);
        }
        if (!CollectionUtils.isEmpty(this.abstractWeChatEventListeners)) {
            Map<WeChatEventTypeEnum, List<AbstractWeChatEventListener>> eventMap = this.abstractWeChatEventListeners.stream().collect(Collectors.groupingBy(AbstractWeChatEventListener::supportEventType));
            eventMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BeanCreationException("\u5fae\u4fe1eventListener\u4e0d\u80fd\u6ce8\u518c\u591a\u6b21");
                }
                this.eventListenerMap.put((WeChatEventTypeEnum)((Object)k), (AbstractWeChatEventListener)v.get(0));
            });
        }
        for (WeChatEventTypeEnum value : eventValues = WeChatEventTypeEnum.values()) {
            if (this.eventListenerMap.containsKey((Object)value)) continue;
            LoggerUtils.warn(logger, value.getDescription() + "\u4e8b\u4ef6\u5904\u7406\u5668\u672a\u6ce8\u518c!!!", new Object[0]);
        }
    }

    public String dispatcher(HttpServletRequest request) {
        Future future = this.eventBusThreadPool.submit(() -> {
            ServletInputStream inputStream = request.getInputStream();
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
            return this.handlerWeiXinMessage(reader);
        });
        try {
            return (String)future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Enumeration parameterNames = request.getParameterNames();
            JSONObject jsonObject = new JSONObject();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                jsonObject.put(name, (Object)request.getParameter(name));
            }
            logger.error("\u4e8b\u4ef6\u5206\u53d1\u5904\u7406\u51fa\u73b0\u5f02\u5e38,\u5fae\u4fe1\u53c2\u6570:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)jsonObject.toJSONString(), (Object)e);
            return "";
        }
    }

    public String dispatcher(byte[] bytes, String uri) throws AesException {
        if (this.weChatProperties.isEnableMessageEnc()) {
            String[] split;
            String inputXML = new String(bytes, StandardCharsets.UTF_8);
            HashMap<String, String> map = new HashMap<String, String>(16);
            int index = uri.indexOf("?");
            String str = uri.substring(index + 1);
            for (String s : split = str.split("&")) {
                String[] arr = s.split("=");
                map.put(arr[0], arr[1]);
            }
            String msgSignature = (String)map.get("msg_signature");
            String timestamp = (String)map.get("timestamp");
            String nonce = (String)map.get("nonce");
            String decryptMsg = this.weChatMsgCodec.decryptMsg(msgSignature, timestamp, nonce, inputXML);
            LoggerUtils.debug(logger, "\u5fae\u4fe1\u6d88\u606f\u89e3\u5bc6\u6210\u529f\uff0c\u4fe1\u606f\u4e3a:{}", decryptMsg);
            bytes = decryptMsg.getBytes(StandardCharsets.UTF_8);
        }
        String result = this.dispatcher(bytes);
        if (this.weChatProperties.isEnableMessageEnc()) {
            result = this.weChatMsgCodec.encrypt(result);
            LoggerUtils.debug(logger, "\u5fae\u4fe1\u6d88\u606f\u52a0\u5bc6\u6210\u529f\uff0c\u4fe1\u606f\u4e3a:{}", result);
        }
        return result;
    }

    public String dispatcher(byte[] bytes) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            InputStreamReader reader = new InputStreamReader(inputStream);
            return this.handlerWeiXinMessage(reader);
        }
        catch (Exception e) {
            logger.error("\u4e8b\u4ef6\u5206\u53d1\u5904\u7406\u51fa\u73b0\u5f02\u5e38,\u5fae\u4fe1\u53c2\u6570:{},\u5f02\u5e38\u4fe1\u606f:", (Object)new String(bytes, StandardCharsets.UTF_8), (Object)e);
            return "";
        }
    }

    private String handlerWeiXinMessage(Reader reader) throws IOException {
        String msgType;
        ObjectNode objectNode = (ObjectNode)XML_MAPPER.readValue(reader, ObjectNode.class);
        switch (msgType = objectNode.get("MsgType").textValue()) {
            case "text": {
                AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), TextMessage.class);
                return this.handlerMessage(abstractWeChatMessage, WeChatMessageTypeEnum.TEXT);
            }
            case "image": {
                AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ImageMessage.class);
                return this.handlerMessage(abstractWeChatMessage, WeChatMessageTypeEnum.IMAGE);
            }
            case "voice": {
                AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), VoiceMessage.class);
                return this.handlerMessage(abstractWeChatMessage, WeChatMessageTypeEnum.VOICE);
            }
            case "video": {
                AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), VideoMessage.class);
                return this.handlerMessage(abstractWeChatMessage, WeChatMessageTypeEnum.VIDEO);
            }
            case "shortvideo": {
                AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ShortVideoMessage.class);
                return this.handlerMessage(abstractWeChatMessage, WeChatMessageTypeEnum.SHORT_VIDEO);
            }
            case "location": {
                AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LocationMessage.class);
                return this.handlerMessage(abstractWeChatMessage, WeChatMessageTypeEnum.LOCATION);
            }
            case "link": {
                AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LinkMessage.class);
                return this.handlerMessage(abstractWeChatMessage, WeChatMessageTypeEnum.LINK);
            }
            case "event": {
                String event;
                switch (event = objectNode.get("Event").textValue()) {
                    case "subscribe": {
                        if (Objects.isNull(objectNode.get("EventKey"))) {
                            AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeEventMessage.class);
                            return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.SUBSCRIBE);
                        }
                        String eventKey = objectNode.get("EventKey").textValue();
                        if (eventKey != null && eventKey.contains("qrscene_")) {
                            AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeQrsceneEventMessage.class);
                            return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.SUBSCRIBE_QRSCENE);
                        }
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.SUBSCRIBE);
                    }
                    case "unsubscribe": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), UnSubscribeEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.UNSUBSCRIBE);
                    }
                    case "SCAN": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeScanEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.SCAN);
                    }
                    case "LOCATION": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LocationEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.LOCATION);
                    }
                    case "TEMPLATESENDJOBFINISH": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), TemplateEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.TEMPLATESENDJOBFINISH);
                    }
                    case "CLICK": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ClickMenuGetInfoEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.CLICK);
                    }
                    case "VIEW": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ClickMenuGotoLinkEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                    case "scancode_push": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ScancodePushEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                    case "scancode_waitmsg": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ScancodeWaitmsgEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                    case "pic_sysphoto": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), PicSysphotoEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                    case "pic_photo_or_album": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), PicPhotoOrAlbumEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                    case "pic_weixin": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), PicWeChatEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                    case "location_select": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LocationSelectEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                    case "view_miniprogram": {
                        AbstractWeChatMessage abstractWeChatMessage = (AbstractWeChatMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ViewMiniProgramEventMessage.class);
                        return this.handlerEvent(abstractWeChatMessage, WeChatEventTypeEnum.VIEW);
                    }
                }
                if (Objects.isNull(this.unKnowWeChatEventListener)) {
                    throw new IllegalArgumentException("\u672a\u77e5\u7684\u4e8b\u4ef6\u8bf7\u6c42\u4fe1\u606f\u7c7b\u578b\uff0cevent:" + event + ",\u8bf7\u6c42\u6570\u636e\u4fe1\u606f:" + objectNode.toString());
                }
                return this.unKnowWeChatEventListener.handlerOtherType(objectNode);
            }
        }
        if (Objects.isNull(this.unKnowWeChatMessageListener)) {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6d88\u606f\u8bf7\u6c42\u4fe1\u606f\u7c7b\u578b,messageType:" + msgType + ",\u8bf7\u6c42\u6570\u636e\u4fe1\u606f:" + objectNode.toString());
        }
        return this.unKnowWeChatMessageListener.handlerOtherType(objectNode);
    }

    private String handlerMessage(AbstractWeChatMessage abstractWeChatMessage, WeChatMessageTypeEnum weChatMessageTypeEnum) {
        if (CollectionUtils.isEmpty(this.abstractWeChatMessageListeners)) {
            throw new IllegalArgumentException("\u672a\u6ce8\u518c\u4efb\u4f55\u76f8\u5173\u6d88\u606f\u76d1\u542c\u5668\uff0c\u6216\u76d1\u542c\u5668\u672a\u52a0\u5165\u5230ioc\u5bb9\u5668\u4e2d");
        }
        AbstractWeChatMessageListener abstractWeChatMessageListener = this.messageListenerMap.get((Object)weChatMessageTypeEnum);
        if (Objects.isNull(abstractWeChatMessageListener)) {
            throw new IllegalArgumentException(weChatMessageTypeEnum.name() + "\u6d88\u606f\u76d1\u542c\u5668\u672a\u6ce8\u518c");
        }
        LoggerUtils.debug(logger, "\u63a5\u6536\u5230\u5fae\u4fe1\u8bf7\u6c42\uff0c\u8bf7\u6c42\u7c7b\u578b:{},\u8bf7\u6c42\u53c2\u6570:{}", weChatMessageTypeEnum.getDescription(), JSON.toJSONString((Object)abstractWeChatMessage));
        WeChatMessageResponse response = abstractWeChatMessageListener.handler(abstractWeChatMessage);
        if (Objects.isNull(response)) {
            return "";
        }
        String toUserName = abstractWeChatMessage.getToUserName();
        String fromUserName = abstractWeChatMessage.getFromUserName();
        response.setFromUserName(toUserName);
        response.setCreateTime(System.currentTimeMillis() / 1000L);
        response.setToUserName(fromUserName);
        try {
            String res = XML_MAPPER.writeValueAsString((Object)response);
            LoggerUtils.debug(logger, "\u8fd4\u56de\u5fae\u4fe1\u5e94\u7b54\u4fe1\u606f\uff0c\u53c2\u6570:{}", res);
            return res;
        }
        catch (JsonProcessingException e) {
            LoggerUtils.error(logger, "jackson \u8f6cxml\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570:" + JSON.toJSONString((Object)response), e);
            return "";
        }
    }

    private String handlerEvent(AbstractWeChatMessage abstractWeChatMessage, WeChatEventTypeEnum weChatEventTypeEnum) {
        if (CollectionUtils.isEmpty(this.abstractWeChatEventListeners)) {
            throw new IllegalArgumentException("\u672a\u6ce8\u518c\u76f8\u5173\u4e8b\u4ef6\u76d1\u542c\u5668\uff0c\u6216\u76d1\u542c\u5668\u672a\u52a0\u5165\u5230ioc\u5bb9\u5668\u4e2d");
        }
        AbstractWeChatEventListener abstractWeChatEventListener = this.eventListenerMap.get((Object)weChatEventTypeEnum);
        if (Objects.isNull(abstractWeChatEventListener)) {
            throw new IllegalArgumentException(weChatEventTypeEnum.name() + "\u4e8b\u4ef6\u76d1\u542c\u5668\u672a\u6ce8\u518c");
        }
        WeChatMessageResponse response = abstractWeChatEventListener.handler(abstractWeChatMessage);
        if (Objects.isNull(response)) {
            return "";
        }
        String toUserName = abstractWeChatMessage.getToUserName();
        String fromUserName = abstractWeChatMessage.getFromUserName();
        response.setFromUserName(toUserName);
        response.setCreateTime(System.currentTimeMillis() / 1000L);
        response.setToUserName(fromUserName);
        try {
            return XML_MAPPER.writeValueAsString((Object)response);
        }
        catch (JsonProcessingException e) {
            LoggerUtils.error(logger, "jackson \u8f6cxml\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570:" + JSON.toJSONString((Object)response), e);
            return "";
        }
    }
}

