/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jlxxw.wechat.function.token.WeChatTokenManager;
import net.jlxxw.wechat.mapper.TokenMapper;
import net.jlxxw.wechat.properties.WeChatProperties;
import net.jlxxw.wechat.schedul.ScheduledUpdateToken;
import net.jlxxw.wechat.schedul.ScheduledUpdateWeChatServerIp;
import net.jlxxw.wechat.security.WeChatServerSecurityCheck;
import net.jlxxw.wechat.util.LoggerUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

@Configuration
@ComponentScan(value={"net.jlxxw.wechat"})
@EnableScheduling
@MapperScan(value={"net.jlxxw.wechat.mapper"})
public class WeChatComponentAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WeChatComponentAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate() {
        return new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((org.apache.http.client.HttpClient)HttpClientBuilder.create().build()));
    }

    @Bean(value={"batchExecuteThreadPool"})
    public ThreadPoolTaskExecutor batchExecuteThreadPool() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        int i = Runtime.getRuntime().availableProcessors();
        executor.setCorePoolSize(i);
        executor.setMaxPoolSize(i * 2);
        executor.setQueueCapacity(100000);
        executor.setKeepAliveSeconds(1000);
        executor.setThreadNamePrefix("batch-execute-pool-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean(value={"eventBusThreadPool"})
    public ThreadPoolTaskExecutor eventBusThreadPool() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        int i = Runtime.getRuntime().availableProcessors();
        executor.setCorePoolSize(i * 2 - 1);
        executor.setMaxPoolSize(i * 4);
        executor.setQueueCapacity(1000);
        executor.setKeepAliveSeconds(1000);
        executor.setThreadNamePrefix("eventBus-execute-pool-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean
    @ConditionalOnProperty(prefix="we-chat", name={"enable-default-token-manager"}, havingValue="true")
    public ScheduledUpdateToken weiXinTokenManager(TokenMapper tokenMapper, WeChatTokenManager weChatTokenManager) {
        LoggerUtils.info(logger, "\u521d\u59cb\u5316\u9ed8\u8ba4token\u7ba1\u7406\u5668", new Object[0]);
        return new ScheduledUpdateToken(tokenMapper, weChatTokenManager);
    }

    @Bean
    @ConditionalOnProperty(prefix="we-chat", name={"enable-we-chat-call-back-server-security-check"}, havingValue="true")
    public ScheduledUpdateWeChatServerIp scheduledUpdateWeChatServerIp(WeChatTokenManager weChatTokenManager, RestTemplate restTemplate, WeChatServerSecurityCheck weChatServerSecurityCheck, WeChatProperties weChatProperties) {
        LoggerUtils.info(logger, "\u521d\u59cb\u5316\u5fae\u4fe1\u5b89\u5168\u68c0\u67e5\u7ec4\u4ef6", new Object[0]);
        return new ScheduledUpdateWeChatServerIp(weChatTokenManager, restTemplate, weChatServerSecurityCheck, weChatProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="we-chat", name={"enable-we-chat-call-back-server-security-check"}, havingValue="true")
    public WeChatServerSecurityCheck weChatServerSecurityCheck() {
        LoggerUtils.info(logger, "\u542f\u7528\u5fae\u4fe1\u56de\u8c03ip\u767d\u540d\u5355\u7ba1\u7406\u5668", new Object[0]);
        return new WeChatServerSecurityCheck();
    }

    @Bean
    @ConditionalOnMissingBean(value={WebClient.class})
    public WebClient webClient() {
        LoggerUtils.info(logger, "\u521d\u59cb\u5316WebClient", new Object[0]);
        TcpClient tcpClient = TcpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000).doOnConnected(connection -> {
            connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(5000L, TimeUnit.MILLISECONDS));
            connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler(5000L, TimeUnit.MILLISECONDS));
        });
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.from((TcpClient)tcpClient))).exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();
    }
}

