/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.schedul;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import javax.annotation.PostConstruct;
import net.jlxxw.wechat.function.token.WeiXinTokenManager;
import net.jlxxw.wechat.properties.WeiXinProperties;
import net.jlxxw.wechat.security.WeiXinServerSecurityCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class ScheduledUpdateWeiXinServerIp {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledUpdateWeiXinServerIp.class);
    private WeiXinTokenManager weiXinTokenManager;
    private RestTemplate restTemplate;
    private WeiXinServerSecurityCheck weiXinServerSecurityCheck;
    private WeiXinProperties weiXinProperties;

    public ScheduledUpdateWeiXinServerIp(WeiXinTokenManager weiXinTokenManager, RestTemplate restTemplate, WeiXinServerSecurityCheck weiXinServerSecurityCheck, WeiXinProperties weiXinProperties) {
        this.weiXinTokenManager = weiXinTokenManager;
        this.restTemplate = restTemplate;
        this.weiXinServerSecurityCheck = weiXinServerSecurityCheck;
        this.weiXinProperties = weiXinProperties;
    }

    @PostConstruct
    @Scheduled(cron="00 00 3,6,9,12,15,18,21 * * ?")
    public void update() {
        if (!this.weiXinProperties.isEnableWeiXinCallBackServerSecurityCheck()) {
            return;
        }
        if (this.weiXinTokenManager == null) {
            throw new BeanCreationException("\u68c0\u67e5\u5fae\u4fe1\u767d\u540d\u5355\u65f6\uff0c\u5fc5\u987b\u914d\u7f6eWeiXinTokenManager\u7684\u5b9e\u73b0\u7c7b\uff0c\u6216\u914d\u7f6eweixin.enable-default-token-manager: true");
        }
        String tokenFromLocal = this.weiXinTokenManager.getTokenFromLocal();
        String forObject = (String)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=" + tokenFromLocal, String.class, new Object[0]);
        JSONObject jsonObject = JSONObject.parseObject((String)forObject);
        JSONArray ipList = jsonObject.getJSONArray("ip_list");
        if (!CollectionUtils.isEmpty((Collection)ipList)) {
            this.weiXinServerSecurityCheck.updateWeiXinServerIp(ipList.toJavaList(String.class));
        }
    }
}

