/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.schedul;

import java.time.LocalDateTime;
import java.util.Date;
import net.jlxxw.wechat.exception.WeiXinException;
import net.jlxxw.wechat.function.token.WeiXinTokenManager;
import net.jlxxw.wechat.mapper.TokenMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@ConditionalOnProperty(prefix="weixin", name={"enable-default-token-manager"}, havingValue="true")
public class ScheduledUpdateToken {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledUpdateToken.class);
    private TokenMapper tokenMapper;
    private WeiXinTokenManager weiXinTokenManager;

    public ScheduledUpdateToken(TokenMapper tokenMapper, WeiXinTokenManager weiXinTokenManager) {
        this.tokenMapper = tokenMapper;
        this.weiXinTokenManager = weiXinTokenManager;
    }

    @Scheduled(cron="0 0 */2 * * ?")
    public void updateToken() throws WeiXinException {
        Date date = this.tokenMapper.lockSelectMaxDate();
        if (date == null) {
            String token = this.weiXinTokenManager.getTokenFromWeiXin();
            this.weiXinTokenManager.saveToken(token);
            logger.info("\u66f4\u65b0token\u6210\u529f\uff0c\u5f53\u524d\u65f6\u95f4:{}", (Object)LocalDateTime.now().toString());
            return;
        }
        long dbTime = date.getTime();
        long current = System.currentTimeMillis();
        if (current - dbTime < 10800L) {
            return;
        }
        String token = this.weiXinTokenManager.getTokenFromWeiXin();
        this.weiXinTokenManager.saveToken(token);
        logger.info("\u66f4\u65b0token\u6210\u529f\uff0c\u5f53\u524d\u65f6\u95f4:{}", (Object)LocalDateTime.now().toString());
    }
}

