/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.response;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Arrays;
import java.util.List;
import net.jlxxw.wechat.response.Article;
import net.jlxxw.wechat.response.Image;
import net.jlxxw.wechat.response.Music;
import net.jlxxw.wechat.response.Video;
import net.jlxxw.wechat.response.Voice;

@JacksonXmlRootElement(localName="xml")
public class WeiXinMessageResponse {
    @JacksonXmlCData
    private String toUserName;
    @JacksonXmlCData
    private String fromUserName;
    private Long createTime;
    @JacksonXmlCData
    private String msgType;
    @JacksonXmlCData
    private String content;
    private Integer articleCount;
    private List<Article> Articles;
    private Image image;
    private Music music;
    private Video video;
    private Voice voice;

    public String getToUserName() {
        return this.toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getArticleCount() {
        return this.articleCount;
    }

    public void setArticleCount(Integer articleCount) {
        this.articleCount = articleCount;
    }

    public List<Article> getArticles() {
        return this.Articles;
    }

    public void setArticles(List<Article> articles) {
        this.Articles = articles;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Music getMusic() {
        return this.music;
    }

    public void setMusic(Music music) {
        this.music = music;
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    public static WeiXinMessageResponse buildText(String content) {
        WeiXinMessageResponse weiXinMessageResponse = new WeiXinMessageResponse();
        weiXinMessageResponse.setMsgType("text");
        weiXinMessageResponse.setContent(content);
        return weiXinMessageResponse;
    }

    public static WeiXinMessageResponse buildImage(String mediaId) {
        WeiXinMessageResponse weiXinMessageResponse = new WeiXinMessageResponse();
        weiXinMessageResponse.setMsgType("image");
        Image image = new Image();
        image.setMediaId(mediaId);
        weiXinMessageResponse.setImage(image);
        return weiXinMessageResponse;
    }

    public static WeiXinMessageResponse buildVoice(String mediaId) {
        WeiXinMessageResponse weiXinMessageResponse = new WeiXinMessageResponse();
        weiXinMessageResponse.setMsgType("voice");
        Voice voice = new Voice();
        voice.setMediaId(mediaId);
        weiXinMessageResponse.setVoice(voice);
        return weiXinMessageResponse;
    }

    public static WeiXinMessageResponse buildVideo(String mediaId, String title, String description) {
        WeiXinMessageResponse weiXinMessageResponse = new WeiXinMessageResponse();
        weiXinMessageResponse.setMsgType("video");
        Video video = new Video();
        video.setMediaId(mediaId);
        video.setTitle(title);
        video.setDescription(description);
        weiXinMessageResponse.setVideo(video);
        return weiXinMessageResponse;
    }

    public static WeiXinMessageResponse buildMusic(String title, String description, String musicUrl, String hqMusicUrl, String thumbMediaId) {
        WeiXinMessageResponse weiXinMessageResponse = new WeiXinMessageResponse();
        weiXinMessageResponse.setMsgType("music");
        Music music = new Music();
        music.setTitle(title);
        music.setDescription(description);
        music.setMusicURL(musicUrl);
        music.sethQMusicUrl(hqMusicUrl);
        music.setThumbMediaId(thumbMediaId);
        weiXinMessageResponse.setMusic(music);
        return weiXinMessageResponse;
    }

    public static WeiXinMessageResponse buildArticle(Article ... articles) {
        WeiXinMessageResponse weiXinMessageResponse = new WeiXinMessageResponse();
        weiXinMessageResponse.setMsgType("news");
        weiXinMessageResponse.setArticleCount(articles.length);
        weiXinMessageResponse.setArticles(Arrays.asList(articles));
        return weiXinMessageResponse;
    }
}

