/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.token;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.PostConstruct;
import net.jlxxw.wechat.exception.WeiXinException;
import net.jlxxw.wechat.function.token.WeiXinTokenManager;
import net.jlxxw.wechat.mapper.TokenMapper;
import net.jlxxw.wechat.properties.WeiXinProperties;
import net.jlxxw.wechat.response.WeiXinResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"tokenMapper", "weiXinProperties"})
@ConditionalOnProperty(prefix="weixin", value={"enable-default-token-manager"}, havingValue="true")
@Component
public class DefaultWeiXinTokenManagerImpl
implements WeiXinTokenManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWeiXinTokenManagerImpl.class);
    @Autowired
    private WeiXinProperties weiXinProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TokenMapper tokenMapper;

    @Override
    public void saveToken(String token) {
        this.tokenMapper.insert(token);
    }

    @Override
    public String getTokenFromWeiXin() throws WeiXinException {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={0}&secret={1}", this.weiXinProperties.getAppId(), this.weiXinProperties.getSecret());
        WeiXinResponse response = (WeiXinResponse)this.restTemplate.getForObject(url, WeiXinResponse.class, new Object[0]);
        if (Objects.nonNull(response.getErrcode()) && 0 != response.getErrcode()) {
            logger.error("\u5fae\u4fe1\u83b7\u53d6token\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)response));
            WeiXinException weiXinException = new WeiXinException(JSON.toJSONString((Object)response));
            weiXinException.setErrorCode(response.getErrcode());
            throw weiXinException;
        }
        return response.getAccess_token();
    }

    @Override
    public String getTokenFromLocal() {
        return this.tokenMapper.getToken();
    }

    @PostConstruct
    public void postConstruct() {
        this.tokenMapper.createTable();
    }
}

