/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.qrcode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import net.jlxxw.wechat.dto.qrcode.QrCodeDTO;
import net.jlxxw.wechat.dto.qrcode.TempQrCodeDTO;
import net.jlxxw.wechat.function.token.WeiXinTokenManager;
import net.jlxxw.wechat.util.WebClientUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Lazy
@DependsOn(value={"weiXinProperties", "weiXinTokenManager", "webClientUtils"})
@Component
public class AsyncQrcodeManager {
    @Autowired
    private WeiXinTokenManager weiXinTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public Mono<TempQrCodeDTO> createTempStringQrcode(String eventKey, Long expireSecond) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), TempQrCodeDTO.class);
    }

    public Mono<TempQrCodeDTO> createTempIdQrcode(Long id, Long expireSecond) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), TempQrCodeDTO.class);
    }

    public Mono<QrCodeDTO> createStringQrcode(String eventKey) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), QrCodeDTO.class);
    }

    public Mono<QrCodeDTO> createIdQrcode(Long id) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        return this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), QrCodeDTO.class);
    }
}

