/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.push;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.jlxxw.wechat.component.BatchExecutor;
import net.jlxxw.wechat.dto.template.WxTemplate;
import net.jlxxw.wechat.response.WeiXinResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lazy
@DependsOn(value={"weiXinProperties", "weiXinTokenManager", "webClientUtils"})
@Component
public class SyncPushTemplate {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BatchExecutor batchExecutor;
    private static final int TOKEN_ERROR = 40001;
    private volatile String volatileToken;

    public WeiXinResponse pushTemplate(WxTemplate template, String token) {
        Objects.requireNonNull(template);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("token error");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)template);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + token, (Object)request, WeiXinResponse.class, new Object[0]);
        WeiXinResponse body = (WeiXinResponse)responseEntity.getBody();
        if (Objects.isNull(body)) {
            return null;
        }
        body.setOpenId(template.getTouser());
        return body;
    }

    public List<WeiXinResponse> pushTemplate(List<WxTemplate> templateList, String token, Supplier<String> getTokenFunction) {
        if (CollectionUtils.isEmpty(templateList)) {
            return new ArrayList<WeiXinResponse>();
        }
        ArrayList<WeiXinResponse> responseList = new ArrayList<WeiXinResponse>();
        this.volatileToken = token;
        this.batchExecutor.batchExecute(true, templateList, list -> {
            for (WxTemplate wxTemplate : list) {
                WeiXinResponse weiXinResponse = this.pushTemplate(wxTemplate, this.volatileToken);
                if (weiXinResponse != null && weiXinResponse.getErrcode() == 40001) {
                    this.volatileToken = (String)getTokenFunction.get();
                }
                responseList.add(weiXinResponse);
            }
        });
        return responseList;
    }
}

