/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.push;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jlxxw.wechat.component.BatchExecutor;
import net.jlxxw.wechat.dto.customer.CustomerMessageDTO;
import net.jlxxw.wechat.response.WeiXinResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lazy
@DependsOn(value={"weiXinProperties", "weiXinTokenManager", "webClientUtils"})
@Component
public class SyncPushCustomer {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BatchExecutor batchExecutor;

    public WeiXinResponse pushCustomer(CustomerMessageDTO messageDTO, String token) {
        Objects.requireNonNull(messageDTO);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("token error");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String json = JSON.toJSONString((Object)messageDTO);
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity("https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=" + token, (Object)request, WeiXinResponse.class, new Object[0]);
        WeiXinResponse body = (WeiXinResponse)responseEntity.getBody();
        if (Objects.isNull(body)) {
            return null;
        }
        body.setOpenId(messageDTO.getTouser());
        return body;
    }

    public List<WeiXinResponse> pushCustomer(List<CustomerMessageDTO> messageList, String token) {
        if (CollectionUtils.isEmpty(messageList)) {
            return new ArrayList<WeiXinResponse>();
        }
        ArrayList<WeiXinResponse> responseList = new ArrayList<WeiXinResponse>();
        this.batchExecutor.batchExecute(true, messageList, list -> {
            for (CustomerMessageDTO message : list) {
                WeiXinResponse weiXinResponse = this.pushCustomer(message, token);
                responseList.add(weiXinResponse);
            }
        });
        return responseList;
    }
}

