/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.menu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.List;
import net.jlxxw.wechat.dto.menu.MenuDTO;
import net.jlxxw.wechat.function.token.WeiXinTokenManager;
import net.jlxxw.wechat.response.WeiXinResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import net.jlxxw.wechat.util.WebClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

@DependsOn(value={"weiXinProperties", "weiXinTokenManager", "webClientUtils"})
@Component
public class AsyncMenuManager {
    private static final Logger logger = LoggerFactory.getLogger(AsyncMenuManager.class);
    @Autowired
    private WeiXinTokenManager weiXinTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public Mono<WeiXinResponse> createMenu(List<MenuDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            LoggerUtils.debug(logger, "\u521b\u5efa\u516c\u4f17\u53f7\u83dc\u5355\uff0c\u8f93\u5165\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a", new Object[0]);
            return Mono.error((Throwable)new NullPointerException("\u521b\u5efa\u516c\u4f17\u53f7\u83dc\u5355\uff0c\u8f93\u5165\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a"));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("button", list);
        String json = JSON.toJSONString((Object)jsonObject);
        LoggerUtils.debug(logger, "\u521b\u5efa\u516c\u4f17\u53f7\u83dc\u5355\uff0c\u8bf7\u6c42\u53c2\u6570:{}", json);
        String url = MessageFormat.format(" https://api.weixin.qq.com/cgi-bin/menu/create?access_token={0}", this.weiXinTokenManager.getTokenFromLocal());
        return this.webClientUtils.sendPostJSON(url, json, WeiXinResponse.class);
    }
}

