/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.function.api;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import net.jlxxw.wechat.function.token.WeiXinTokenManager;
import net.jlxxw.wechat.properties.WeiXinProperties;
import net.jlxxw.wechat.response.WeiXinResponse;
import net.jlxxw.wechat.response.api.ApiRequestRecord;
import net.jlxxw.wechat.response.api.ApiResult;
import net.jlxxw.wechat.util.WebClientUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Lazy
@DependsOn(value={"weiXinProperties", "weiXinTokenManager", "webClientUtils"})
@Component
public class AsyncOpenApiManager {
    @Autowired
    private WeiXinProperties weiXinProperties;
    @Autowired
    private WeiXinTokenManager weiXinTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public Mono<WeiXinResponse> clean() {
        String appId = this.weiXinProperties.getAppId();
        String token = this.weiXinTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/clear_quota?access_token={0}", token);
        return this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), WeiXinResponse.class);
    }

    public Mono<ApiResult> selectQuota(String cgiPath) {
        if (StringUtils.isBlank((String)cgiPath)) {
            throw new NullPointerException();
        }
        String appId = this.weiXinProperties.getAppId();
        String token = this.weiXinTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/quota/get?access_token={0}", token);
        return this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), ApiResult.class);
    }

    public Mono<ApiRequestRecord> selectRid(String rid) {
        if (StringUtils.isBlank((String)rid)) {
            throw new NullPointerException();
        }
        String appId = this.weiXinProperties.getAppId();
        String token = this.weiXinTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/quota/get?access_token={0}", token);
        return this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), ApiRequestRecord.class);
    }
}

