/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.annotation.PostConstruct;
import net.jlxxw.wechat.component.netty.WeiXinChannel;
import net.jlxxw.wechat.properties.WeiXinNettyServerProperties;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeiXinCoreComponent {
    private static final ServerBootstrap BOOTSTRAP = new ServerBootstrap();
    private static final Logger logger = LoggerFactory.getLogger(WeiXinCoreComponent.class);
    @Autowired
    private WeiXinNettyServerProperties weiXinNettyServerProperties;
    @Autowired
    private WeiXinChannel weiXinChannel;

    @PostConstruct
    public void postConstruct() {
        if (!this.weiXinNettyServerProperties.getEnableNetty().booleanValue()) {
            return;
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LoggerUtils.info(logger, "\u521d\u59cb\u5316 netty \u7ec4\u4ef6", new Object[0]);
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                NioEventLoopGroup workGroup = new NioEventLoopGroup(WeiXinCoreComponent.this.weiXinNettyServerProperties.getMaxThreadSize().intValue());
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)BOOTSTRAP.group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel socketChannel) throws Exception {
                        socketChannel.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u8bf7\u6c42\u89e3\u7801\u5668 \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(65535));
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty http\u805a\u5408\u5668 \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u54cd\u5e94\u7f16\u7801\u5668 \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u5206\u5757\u5199\u5165\u5904\u7406\u7a0b\u5e8f \u6210\u529f", new Object[0]);
                        socketChannel.pipeline().addLast("http-server", (ChannelHandler)WeiXinCoreComponent.this.weiXinChannel);
                        LoggerUtils.debug(logger, "\u521d\u59cb\u5316 netty \u5fae\u4fe1\u534f\u8bae\u5904\u7406\u5668 \u6210\u529f", new Object[0]);
                    }
                }).localAddress(WeiXinCoreComponent.this.weiXinNettyServerProperties.getNettyPort().intValue())).option(ChannelOption.SO_BACKLOG, (Object)WeiXinCoreComponent.this.weiXinNettyServerProperties.getQueueSize())).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
                try {
                    ChannelFuture future = BOOTSTRAP.bind(WeiXinCoreComponent.this.weiXinNettyServerProperties.getNettyPort().intValue()).sync();
                    LoggerUtils.info(logger, "\u5fae\u4fe1netty\u670d\u52a1\u542f\u52a8\uff0c\u5f00\u59cb\u76d1\u542c\u7aef\u53e3: {}", WeiXinCoreComponent.this.weiXinNettyServerProperties.getNettyPort());
                    future.channel().closeFuture().sync();
                }
                catch (InterruptedException e) {
                    LoggerUtils.error(logger, "\u5fae\u4fe1netty\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff01\uff01\uff01", e);
                    System.exit(0);
                }
                finally {
                    bossGroup.shutdownGracefully();
                    workGroup.shutdownGracefully();
                }
            }
        };
        t.setName("weixin-netty-thread-listener");
        t.setDaemon(false);
        t.start();
    }
}

