/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.jlxxw.wechat.enums.AesExceptionEnum;
import net.jlxxw.wechat.exception.AesException;
import net.jlxxw.wechat.properties.WeiXinProperties;
import net.jlxxw.wechat.util.ByteGroup;
import net.jlxxw.wechat.util.PKCS7Encoder;
import net.jlxxw.wechat.util.SHA1;
import net.jlxxw.wechat.util.XMLParse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"weixin.enable-message-enc"}, havingValue="true")
public class WeiXinMsgCodec {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Base64 BASE64 = new Base64();
    private byte[] aesKey;
    private String token;
    private String appId;
    @Autowired
    private WeiXinProperties weiXinProperties;

    @PostConstruct
    public void postConstruct() throws AesException {
        String encodingAesKey = this.weiXinProperties.getEncodingAesKey();
        if (encodingAesKey.length() != 43) {
            throw new AesException(AesExceptionEnum.ILLEGAL_AES_KEY);
        }
        this.token = this.weiXinProperties.getVerifyToken();
        this.appId = this.weiXinProperties.getAppId();
        this.aesKey = Base64.decodeBase64((String)(encodingAesKey + "="));
    }

    public String decryptMsg(String msgSignature, String timeStamp, String nonce, String postData) throws AesException {
        Object[] encrypt = XMLParse.extract(postData);
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt[1].toString());
        if (!signature.equals(msgSignature)) {
            throw new AesException(AesExceptionEnum.VALIDATE_SIGNATURE_ERROR);
        }
        return this.decrypt(encrypt[1].toString());
    }

    public String encrypt(String text) throws AesException {
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String nonce = this.getRandomStr();
        return this.encryptMsg(text, timeStamp, nonce);
    }

    private String encryptMsg(String replyMsg, String timeStamp, String nonce) throws AesException {
        String encrypt = this.encrypt(this.getRandomStr(), replyMsg);
        if (StringUtils.isBlank((String)timeStamp)) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        return XMLParse.generate(encrypt, signature, timeStamp, nonce);
    }

    private byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    private int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    private String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private String encrypt(String randomStr, String text) throws AesException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] appidBytes = this.appId.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(appidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return BASE64.encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new AesException(AesExceptionEnum.ENCRYPT_AES_ERROR, e);
        }
    }

    private String decrypt(String text) throws AesException {
        String fromAppid;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)keySpec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new AesException(AesExceptionEnum.DECRYPT_AES_ERROR, e);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            fromAppid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            throw new AesException(AesExceptionEnum.ILLEGAL_BUFFER, e);
        }
        if (!fromAppid.equals(this.appId)) {
            throw new AesException(AesExceptionEnum.VALIDATE_APPID_ERROR);
        }
        return xmlContent;
    }
}

