/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.jlxxw.wechat.component.WeiXinMsgCodec;
import net.jlxxw.wechat.component.listener.AbstractWeiXinEventListener;
import net.jlxxw.wechat.component.listener.AbstractWeiXinMessageListener;
import net.jlxxw.wechat.component.listener.UnKnowWeiXinEventListener;
import net.jlxxw.wechat.component.listener.UnKnowWeiXinMessageListener;
import net.jlxxw.wechat.dto.message.AbstractWeiXinMessage;
import net.jlxxw.wechat.dto.message.ImageMessage;
import net.jlxxw.wechat.dto.message.LinkMessage;
import net.jlxxw.wechat.dto.message.LocationMessage;
import net.jlxxw.wechat.dto.message.ShortVideoMessage;
import net.jlxxw.wechat.dto.message.TextMessage;
import net.jlxxw.wechat.dto.message.VideoMessage;
import net.jlxxw.wechat.dto.message.VoiceMessage;
import net.jlxxw.wechat.dto.message.event.ClickMenuGetInfoEventMessage;
import net.jlxxw.wechat.dto.message.event.ClickMenuGotoLinkEventMessage;
import net.jlxxw.wechat.dto.message.event.LocationEventMessage;
import net.jlxxw.wechat.dto.message.event.LocationSelectEventMessage;
import net.jlxxw.wechat.dto.message.event.PicPhotoOrAlbumEventMessage;
import net.jlxxw.wechat.dto.message.event.PicSysphotoEventMessage;
import net.jlxxw.wechat.dto.message.event.PicWeiXinEventMessage;
import net.jlxxw.wechat.dto.message.event.ScancodePushEventMessage;
import net.jlxxw.wechat.dto.message.event.ScancodeWaitmsgEventMessage;
import net.jlxxw.wechat.dto.message.event.SubscribeEventMessage;
import net.jlxxw.wechat.dto.message.event.SubscribeQrsceneEventMessage;
import net.jlxxw.wechat.dto.message.event.SubscribeScanEventMessage;
import net.jlxxw.wechat.dto.message.event.TemplateEventMessage;
import net.jlxxw.wechat.dto.message.event.UnSubscribeEventMessage;
import net.jlxxw.wechat.dto.message.event.ViewMiniProgramEventMessage;
import net.jlxxw.wechat.enums.WeiXinEventTypeEnum;
import net.jlxxw.wechat.enums.WeiXinMessageTypeEnum;
import net.jlxxw.wechat.exception.AesException;
import net.jlxxw.wechat.properties.WeiXinProperties;
import net.jlxxw.wechat.response.WeiXinMessageResponse;
import net.jlxxw.wechat.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventBus {
    private static final Logger logger = LoggerFactory.getLogger(EventBus.class);
    private static final XmlMapper XML_MAPPER = new XmlMapper();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired(required=false)
    private List<AbstractWeiXinMessageListener> abstractWeiXinMessageListeners;
    @Autowired(required=false)
    private List<AbstractWeiXinEventListener> abstractWeiXinEventListeners;
    @Autowired(required=false)
    private WeiXinMsgCodec weiXinMsgCodec;
    @Autowired
    private WeiXinProperties weiXinProperties;
    @Autowired(required=false)
    private UnKnowWeiXinEventListener unKnowWeiXinEventListener;
    @Autowired(required=false)
    private UnKnowWeiXinMessageListener unKnowWeiXinMessageListener;
    @Autowired
    private ThreadPoolTaskExecutor eventBusThreadPool;
    private final Map<WeiXinMessageTypeEnum, AbstractWeiXinMessageListener> messageListenerMap = new HashMap<WeiXinMessageTypeEnum, AbstractWeiXinMessageListener>();
    private final Map<WeiXinEventTypeEnum, AbstractWeiXinEventListener> eventListenerMap = new HashMap<WeiXinEventTypeEnum, AbstractWeiXinEventListener>();

    @PostConstruct
    public void postConstruct() {
        WeiXinEventTypeEnum[] eventValues;
        WeiXinMessageTypeEnum[] values;
        XML_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        XML_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        XML_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        if (!CollectionUtils.isEmpty(this.abstractWeiXinMessageListeners)) {
            Map<WeiXinMessageTypeEnum, List<AbstractWeiXinMessageListener>> map = this.abstractWeiXinMessageListeners.stream().collect(Collectors.groupingBy(AbstractWeiXinMessageListener::supportMessageType));
            map.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BeanCreationException("\u5fae\u4fe1messageListener\u4e0d\u80fd\u6ce8\u518c\u591a\u6b21");
                }
                this.messageListenerMap.put((WeiXinMessageTypeEnum)((Object)k), (AbstractWeiXinMessageListener)v.get(0));
            });
        }
        for (WeiXinMessageTypeEnum value : values = WeiXinMessageTypeEnum.values()) {
            if (this.messageListenerMap.containsKey((Object)value)) continue;
            LoggerUtils.warn(logger, value.getDescription() + "\u6d88\u606f\u5904\u7406\u5668\u672a\u6ce8\u518c!!!", new Object[0]);
        }
        if (!CollectionUtils.isEmpty(this.abstractWeiXinEventListeners)) {
            Map<WeiXinEventTypeEnum, List<AbstractWeiXinEventListener>> eventMap = this.abstractWeiXinEventListeners.stream().collect(Collectors.groupingBy(AbstractWeiXinEventListener::supportEventType));
            eventMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    throw new BeanCreationException("\u5fae\u4fe1eventListener\u4e0d\u80fd\u6ce8\u518c\u591a\u6b21");
                }
                this.eventListenerMap.put((WeiXinEventTypeEnum)((Object)k), (AbstractWeiXinEventListener)v.get(0));
            });
        }
        for (WeiXinEventTypeEnum value : eventValues = WeiXinEventTypeEnum.values()) {
            if (this.eventListenerMap.containsKey((Object)value)) continue;
            LoggerUtils.warn(logger, value.getDescription() + "\u4e8b\u4ef6\u5904\u7406\u5668\u672a\u6ce8\u518c!!!", new Object[0]);
        }
    }

    public String dispatcher(HttpServletRequest request) {
        Future future = this.eventBusThreadPool.submit(() -> {
            ServletInputStream inputStream = request.getInputStream();
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
            return this.handlerWeiXinMessage(reader);
        });
        try {
            return (String)future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Enumeration parameterNames = request.getParameterNames();
            JSONObject jsonObject = new JSONObject();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                jsonObject.put(name, (Object)request.getParameter(name));
            }
            logger.error("\u4e8b\u4ef6\u5206\u53d1\u5904\u7406\u51fa\u73b0\u5f02\u5e38,\u5fae\u4fe1\u53c2\u6570:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)jsonObject.toJSONString(), (Object)e);
            return "";
        }
    }

    public String dispatcher(byte[] bytes, String uri) throws AesException {
        if (this.weiXinProperties.isEnableMessageEnc()) {
            String[] split;
            String inputXML = new String(bytes, StandardCharsets.UTF_8);
            HashMap<String, String> map = new HashMap<String, String>(16);
            int index = uri.indexOf("?");
            String str = uri.substring(index + 1);
            for (String s : split = str.split("&")) {
                String[] arr = s.split("=");
                map.put(arr[0], arr[1]);
            }
            String msgSignature = (String)map.get("msg_signature");
            String timestamp = (String)map.get("timestamp");
            String nonce = (String)map.get("nonce");
            String decryptMsg = this.weiXinMsgCodec.decryptMsg(msgSignature, timestamp, nonce, inputXML);
            LoggerUtils.debug(logger, "\u5fae\u4fe1\u6d88\u606f\u89e3\u5bc6\u6210\u529f\uff0c\u4fe1\u606f\u4e3a:{}", decryptMsg);
            bytes = decryptMsg.getBytes(StandardCharsets.UTF_8);
        }
        String result = this.dispatcher(bytes);
        if (this.weiXinProperties.isEnableMessageEnc()) {
            result = this.weiXinMsgCodec.encrypt(result);
            LoggerUtils.debug(logger, "\u5fae\u4fe1\u6d88\u606f\u52a0\u5bc6\u6210\u529f\uff0c\u4fe1\u606f\u4e3a:{}", result);
        }
        return result;
    }

    public String dispatcher(byte[] bytes) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            InputStreamReader reader = new InputStreamReader(inputStream);
            return this.handlerWeiXinMessage(reader);
        }
        catch (Exception e) {
            logger.error("\u4e8b\u4ef6\u5206\u53d1\u5904\u7406\u51fa\u73b0\u5f02\u5e38,\u5fae\u4fe1\u53c2\u6570:{},\u5f02\u5e38\u4fe1\u606f:", (Object)new String(bytes, StandardCharsets.UTF_8), (Object)e);
            return "";
        }
    }

    private String handlerWeiXinMessage(Reader reader) throws IOException {
        String msgType;
        ObjectNode objectNode = (ObjectNode)XML_MAPPER.readValue(reader, ObjectNode.class);
        switch (msgType = objectNode.get("MsgType").textValue()) {
            case "text": {
                AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), TextMessage.class);
                return this.handlerMessage(abstractWeiXinMessage, WeiXinMessageTypeEnum.TEXT);
            }
            case "image": {
                AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ImageMessage.class);
                return this.handlerMessage(abstractWeiXinMessage, WeiXinMessageTypeEnum.IMAGE);
            }
            case "voice": {
                AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), VoiceMessage.class);
                return this.handlerMessage(abstractWeiXinMessage, WeiXinMessageTypeEnum.VOICE);
            }
            case "video": {
                AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), VideoMessage.class);
                return this.handlerMessage(abstractWeiXinMessage, WeiXinMessageTypeEnum.VIDEO);
            }
            case "shortvideo": {
                AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ShortVideoMessage.class);
                return this.handlerMessage(abstractWeiXinMessage, WeiXinMessageTypeEnum.SHORT_VIDEO);
            }
            case "location": {
                AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LocationMessage.class);
                return this.handlerMessage(abstractWeiXinMessage, WeiXinMessageTypeEnum.LOCATION);
            }
            case "link": {
                AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LinkMessage.class);
                return this.handlerMessage(abstractWeiXinMessage, WeiXinMessageTypeEnum.LINK);
            }
            case "event": {
                String event;
                switch (event = objectNode.get("Event").textValue()) {
                    case "subscribe": {
                        if (Objects.isNull(objectNode.get("EventKey"))) {
                            AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeEventMessage.class);
                            return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.SUBSCRIBE);
                        }
                        String eventKey = objectNode.get("EventKey").textValue();
                        if (eventKey != null && eventKey.contains("qrscene_")) {
                            AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeQrsceneEventMessage.class);
                            return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.SUBSCRIBE_QRSCENE);
                        }
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.SUBSCRIBE);
                    }
                    case "unsubscribe": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), UnSubscribeEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.UNSUBSCRIBE);
                    }
                    case "SCAN": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), SubscribeScanEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.SCAN);
                    }
                    case "LOCATION": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LocationEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.LOCATION);
                    }
                    case "TEMPLATESENDJOBFINISH": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), TemplateEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.TEMPLATESENDJOBFINISH);
                    }
                    case "CLICK": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ClickMenuGetInfoEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.CLICK);
                    }
                    case "VIEW": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ClickMenuGotoLinkEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                    case "scancode_push": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ScancodePushEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                    case "scancode_waitmsg": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ScancodeWaitmsgEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                    case "pic_sysphoto": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), PicSysphotoEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                    case "pic_photo_or_album": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), PicPhotoOrAlbumEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                    case "pic_weixin": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), PicWeiXinEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                    case "location_select": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), LocationSelectEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                    case "view_miniprogram": {
                        AbstractWeiXinMessage abstractWeiXinMessage = (AbstractWeiXinMessage)OBJECT_MAPPER.readValue(objectNode.toString(), ViewMiniProgramEventMessage.class);
                        return this.handlerEvent(abstractWeiXinMessage, WeiXinEventTypeEnum.VIEW);
                    }
                }
                if (Objects.isNull(this.unKnowWeiXinEventListener)) {
                    throw new IllegalArgumentException("\u672a\u77e5\u7684\u4e8b\u4ef6\u8bf7\u6c42\u4fe1\u606f\u7c7b\u578b\uff0cevent:" + event + ",\u8bf7\u6c42\u6570\u636e\u4fe1\u606f:" + objectNode.toString());
                }
                return this.unKnowWeiXinEventListener.handlerOtherType(objectNode);
            }
        }
        if (Objects.isNull(this.unKnowWeiXinMessageListener)) {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6d88\u606f\u8bf7\u6c42\u4fe1\u606f\u7c7b\u578b,messageType:" + msgType + ",\u8bf7\u6c42\u6570\u636e\u4fe1\u606f:" + objectNode.toString());
        }
        return this.unKnowWeiXinMessageListener.handlerOtherType(objectNode);
    }

    private String handlerMessage(AbstractWeiXinMessage abstractWeiXinMessage, WeiXinMessageTypeEnum weiXinMessageTypeEnum) {
        if (CollectionUtils.isEmpty(this.abstractWeiXinMessageListeners)) {
            throw new IllegalArgumentException("\u672a\u6ce8\u518c\u4efb\u4f55\u76f8\u5173\u6d88\u606f\u76d1\u542c\u5668\uff0c\u6216\u76d1\u542c\u5668\u672a\u52a0\u5165\u5230ioc\u5bb9\u5668\u4e2d");
        }
        AbstractWeiXinMessageListener abstractWeiXinMessageListener = this.messageListenerMap.get((Object)weiXinMessageTypeEnum);
        if (Objects.isNull(abstractWeiXinMessageListener)) {
            throw new IllegalArgumentException(weiXinMessageTypeEnum.name() + "\u6d88\u606f\u76d1\u542c\u5668\u672a\u6ce8\u518c");
        }
        LoggerUtils.debug(logger, "\u63a5\u6536\u5230\u5fae\u4fe1\u8bf7\u6c42\uff0c\u8bf7\u6c42\u7c7b\u578b:{},\u8bf7\u6c42\u53c2\u6570:{}", weiXinMessageTypeEnum.getDescription(), JSON.toJSONString((Object)abstractWeiXinMessage));
        WeiXinMessageResponse response = abstractWeiXinMessageListener.handler(abstractWeiXinMessage);
        if (Objects.isNull(response)) {
            return "";
        }
        String toUserName = abstractWeiXinMessage.getToUserName();
        String fromUserName = abstractWeiXinMessage.getFromUserName();
        response.setFromUserName(toUserName);
        response.setCreateTime(System.currentTimeMillis() / 1000L);
        response.setToUserName(fromUserName);
        try {
            String res = XML_MAPPER.writeValueAsString((Object)response);
            LoggerUtils.debug(logger, "\u8fd4\u56de\u5fae\u4fe1\u5e94\u7b54\u4fe1\u606f\uff0c\u53c2\u6570:{}", res);
            return res;
        }
        catch (JsonProcessingException e) {
            LoggerUtils.error(logger, "jackson \u8f6cxml\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570:" + JSON.toJSONString((Object)response), e);
            return "";
        }
    }

    private String handlerEvent(AbstractWeiXinMessage abstractWeiXinMessage, WeiXinEventTypeEnum weiXinEventTypeEnum) {
        if (CollectionUtils.isEmpty(this.abstractWeiXinEventListeners)) {
            throw new IllegalArgumentException("\u672a\u6ce8\u518c\u76f8\u5173\u4e8b\u4ef6\u76d1\u542c\u5668\uff0c\u6216\u76d1\u542c\u5668\u672a\u52a0\u5165\u5230ioc\u5bb9\u5668\u4e2d");
        }
        AbstractWeiXinEventListener abstractWeiXinEventListener = this.eventListenerMap.get((Object)weiXinEventTypeEnum);
        if (Objects.isNull(abstractWeiXinEventListener)) {
            throw new IllegalArgumentException(weiXinEventTypeEnum.name() + "\u4e8b\u4ef6\u76d1\u542c\u5668\u672a\u6ce8\u518c");
        }
        WeiXinMessageResponse response = abstractWeiXinEventListener.handler(abstractWeiXinMessage);
        if (Objects.isNull(response)) {
            return "";
        }
        String toUserName = abstractWeiXinMessage.getToUserName();
        String fromUserName = abstractWeiXinMessage.getFromUserName();
        response.setFromUserName(toUserName);
        response.setCreateTime(System.currentTimeMillis() / 1000L);
        response.setToUserName(fromUserName);
        try {
            return XML_MAPPER.writeValueAsString((Object)response);
        }
        catch (JsonProcessingException e) {
            LoggerUtils.error(logger, "jackson \u8f6cxml\u5931\u8d25\uff0c\u8f93\u5165\u53c2\u6570:" + JSON.toJSONString((Object)response), e);
            return "";
        }
    }
}

