/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.wechat.component;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BatchExecutor {
    @Autowired
    @Qualifier(value="batchExecuteThreadPool")
    private Executor batchExecuteThreadPool;

    private <T> void batchExecute(List<T> data, Consumer<List<T>> consumer) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        int countFor = this.countFor(data.size());
        int start = 0;
        int end = 0;
        for (int i = 0; i < countFor; ++i) {
            if (i < countFor - 1) {
                start = i << 9;
                end = i + 1 << 9;
            } else {
                start = i << 9;
                end = data.size();
            }
            int finalStart = start;
            int finalEnd = end;
            List<T> tempList = data.subList(finalStart, finalEnd);
            consumer.accept(tempList);
        }
    }

    public <T> void batchExecute(boolean useThreadPool, List<T> data, Consumer<List<T>> consumer) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        if (useThreadPool) {
            int countFor = this.countFor(data.size());
            int start = 0;
            int end = 0;
            for (int i = 0; i < countFor; ++i) {
                if (i < countFor - 1) {
                    start = i << 9;
                    end = i + 1 << 9;
                } else {
                    start = i << 9;
                    end = data.size();
                }
                int finalStart = start;
                int finalEnd = end;
                this.batchExecuteThreadPool.execute(() -> {
                    List tempList = data.subList(finalStart, finalEnd);
                    consumer.accept(tempList);
                });
            }
        } else {
            this.batchExecute(data, consumer);
        }
    }

    private int countFor(int size) {
        int i = 512;
        if (size % i == 0) {
            return size / i;
        }
        return size / i + 1;
    }
}

