/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.function.token;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.PostConstruct;
import net.jlxxw.component.weixin.exception.WeiXinException;
import net.jlxxw.component.weixin.function.token.WeiXinTokenManager;
import net.jlxxw.component.weixin.mapper.TokenMapper;
import net.jlxxw.component.weixin.properties.WeiXinProperties;
import net.jlxxw.component.weixin.response.WeiXinResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(prefix="weixin", value={"enable-default-token-manager"}, havingValue="true")
@Component
public class WeiXinTokenManagerImpl
implements WeiXinTokenManager {
    private static final Logger logger = LoggerFactory.getLogger(WeiXinTokenManagerImpl.class);
    @Autowired
    private WeiXinProperties weiXinProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TokenMapper tokenMapper;

    @Override
    public void saveToken(String token) {
        this.tokenMapper.insert(token);
    }

    @Override
    public String getTokenFromWeiXin() {
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={0}&secret={1}", this.weiXinProperties.getAppId(), this.weiXinProperties.getSecret());
        WeiXinResponse response = (WeiXinResponse)this.restTemplate.getForObject(url, WeiXinResponse.class, new Object[0]);
        if (Objects.nonNull(response.getErrcode())) {
            logger.error("\u5fae\u4fe1\u83b7\u53d6token\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)response));
            throw new WeiXinException(JSON.toJSONString((Object)response));
        }
        return response.getAccess_token();
    }

    @Override
    public String getTokenFromLocal() {
        return this.tokenMapper.getToken();
    }

    @PostConstruct
    public void postConstruct() {
        this.tokenMapper.createTable();
    }
}

