/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.function.qrcode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.function.Consumer;
import net.jlxxw.component.weixin.dto.qrcode.QrCodeDTO;
import net.jlxxw.component.weixin.dto.qrcode.TempQrCodeDTO;
import net.jlxxw.component.weixin.function.token.WeiXinTokenManager;
import net.jlxxw.component.weixin.util.WebClientUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class QrcodeManager {
    @Autowired
    private WeiXinTokenManager weiXinTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public void createTempStringQrcode(String eventKey, Long expireSecond, Consumer<TempQrCodeDTO> consumer) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        Mono<TempQrCodeDTO> mono = this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), TempQrCodeDTO.class);
        mono.subscribe(consumer);
    }

    public void createTempIdQrcode(Long id, Long expireSecond, Consumer<TempQrCodeDTO> consumer) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        object.put("expire_seconds", (Object)expireSecond);
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        Mono<TempQrCodeDTO> mono = this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), TempQrCodeDTO.class);
        mono.subscribe(consumer);
    }

    public void createStringQrcode(String eventKey, Consumer<QrCodeDTO> consumer) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)eventKey);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        Mono<QrCodeDTO> mono = this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), QrCodeDTO.class);
        mono.subscribe(consumer);
    }

    public void createIdQrcode(Long id, Consumer<QrCodeDTO> consumer) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token={0}", token);
        JSONObject object = new JSONObject();
        object.put("action_name", (Object)"QR_SCENE");
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)id);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        object.put("action_info", (Object)actionInfo);
        Mono<QrCodeDTO> mono = this.webClientUtils.sendPostJSON(url, JSON.toJSONString((Object)object), QrCodeDTO.class);
        mono.subscribe(consumer);
    }
}

