/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.function.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import net.jlxxw.component.weixin.context.SpringContextHolder;
import net.jlxxw.component.weixin.dto.pay.jsapi.v3.OrderInfoDTO;
import net.jlxxw.component.weixin.event.CreatePrePayEvent;
import net.jlxxw.component.weixin.exception.WeiXinPayException;
import net.jlxxw.component.weixin.properties.WeiXinPayProperties;
import net.jlxxw.component.weixin.properties.WeiXinProperties;
import net.jlxxw.component.weixin.util.RSAUtils;
import net.jlxxw.component.weixin.vo.jsapi.v3.ExecutePayVO;
import net.jlxxw.component.weixin.vo.jsapi.v3.PayResultVO;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WeiXinPay {
    private static final int SUCCESS_CODE = 200;
    private static final String STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeiXinProperties weiXinProperties;
    @Autowired
    private WeiXinPayProperties weiXinPayProperties;
    @Autowired
    private SpringContextHolder springContextHolder;

    public PayResultVO createPrePay(OrderInfoDTO orderInfoDTO, String userAgent) throws WeiXinPayException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headers.add("User-Agent", userAgent);
        String json = JSON.toJSONString((Object)orderInfoDTO);
        HttpEntity formEntity = new HttpEntity((Object)json.toString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity("https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi", (Object)formEntity, JSONObject.class, new Object[0]);
        HttpStatus statusCode = responseEntity.getStatusCode();
        JSONObject body = (JSONObject)responseEntity.getBody();
        if (Objects.isNull(body)) {
            throw new RuntimeException("un known exception ,response body is null");
        }
        if (200 != statusCode.value()) {
            String code = body.getString("code");
            String message = body.getString("message");
            JSONObject detail = body.getJSONObject("detail");
            throw new WeiXinPayException(code, message, detail);
        }
        PayResultVO vo = new PayResultVO();
        vo.setPrePayId(body.getString("prepay_id"));
        HttpHeaders responseHeaders = responseEntity.getHeaders();
        List strings = responseHeaders.get((Object)"Request-ID");
        vo.setRequestId((String)strings.get(0));
        this.springContextHolder.publishEvent(new CreatePrePayEvent(vo));
        return vo;
    }

    public ExecutePayVO getExecutePayVO(String prePayId) throws Exception {
        String appId = this.weiXinProperties.getAppId();
        long l = System.currentTimeMillis() / 1000L;
        int time = (int)l;
        String randomString = RandomStringUtils.random((int)32, (String)STR);
        String str = appId + "\n" + time + "\n" + randomString + "\n" + prePayId + "\n";
        String publicKey = this.weiXinPayProperties.getPublicKey();
        String encode = RSAUtils.encode(str, publicKey);
        ExecutePayVO vo = new ExecutePayVO();
        vo.setAppId(appId);
        vo.setNonceStr(randomString);
        vo.setSignType("RSA");
        vo.setPaySign(encode);
        vo.setPrepayId(prePayId);
        return vo;
    }
}

