/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.function.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import net.jlxxw.component.weixin.enums.MaterialEnum;
import net.jlxxw.component.weixin.exception.WeiXinException;
import net.jlxxw.component.weixin.function.token.WeiXinTokenManager;
import net.jlxxw.component.weixin.util.LoggerUtils;
import net.jlxxw.component.weixin.vo.TempMaterialVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class TempMaterialManager {
    private static final Logger logger = LoggerFactory.getLogger(TempMaterialManager.class);
    @Autowired
    private WebClient webClient;
    @Autowired
    private WeiXinTokenManager weiXinTokenManager;

    @PostConstruct
    public void postConstruct() {
        Objects.requireNonNull(this.webClient);
        Objects.requireNonNull(this.weiXinTokenManager);
    }

    public void upload(MaterialEnum materialEnum, File file, Consumer<TempMaterialVO> callbackMethod) {
        String tokenFromLocal = this.weiXinTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/media/upload?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750url:{}", url);
        Mono mono = ((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)param)).retrieve().bodyToMono(JSONObject.class);
        mono.subscribe(obj -> {
            if (obj.getInteger("errcode") != null) {
                WeiXinException weiXinException = new WeiXinException(JSON.toJSONString((Object)obj));
                weiXinException.setErrorCode(obj.getInteger("errcode"));
                throw weiXinException;
            }
            LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", JSON.toJSONString((Object)obj));
            TempMaterialVO materialVO = new TempMaterialVO();
            materialVO.setMediaId(obj.getString("media_id"));
            materialVO.setCreatedAt(obj.getLong("created_at"));
            materialVO.setType(obj.getString("type"));
            callbackMethod.accept(materialVO);
        });
    }

    public void upload(MaterialEnum materialEnum, URI uri, Consumer<TempMaterialVO> callbackMethod) {
        String tokenFromLocal = this.weiXinTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(Paths.get(uri));
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/media/upload?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750url:{}", url);
        Mono mono = ((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)param)).retrieve().bodyToMono(JSONObject.class);
        mono.subscribe(obj -> {
            if (obj.getInteger("errcode") != null) {
                WeiXinException weiXinException = new WeiXinException(JSON.toJSONString((Object)obj));
                weiXinException.setErrorCode(obj.getInteger("errcode"));
                throw weiXinException;
            }
            LoggerUtils.debug(logger, "\u65b0\u589e\u4e34\u65f6\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", JSON.toJSONString((Object)obj));
            TempMaterialVO materialVO = new TempMaterialVO();
            materialVO.setMediaId(obj.getString("media_id"));
            materialVO.setCreatedAt(obj.getLong("created_at"));
            materialVO.setType(obj.getString("type"));
            callbackMethod.accept(materialVO);
        });
    }

    public void download(String mediaId, MediaType mediaType, Consumer<InputStream> callback) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/media/get/jssdk?access_token={0}&media_id={1}", token, mediaId);
        LoggerUtils.debug(logger, "\u4e0b\u8f7d\u4e34\u65f6\u7d20\u6750,\u4e0d\u542b\u89c6\u9891url:{}", url);
        Mono mono = this.webClient.get().uri(url, new Object[0]).accept(new MediaType[]{mediaType}).retrieve().bodyToMono(Resource.class);
        mono.subscribe(resource -> {
            try (InputStream inputStream = resource.getInputStream();){
                callback.accept(inputStream);
            }
            catch (Exception e) {
                LoggerUtils.error(logger, "\u4e0b\u8f7d\u4e34\u65f6\u7d20\u6750\u51fa\u73b0\u5f02\u5e38,mediaId:" + mediaId + ",mediaType:" + mediaType, e);
                throw new WeiXinException(e.getMessage());
            }
        });
    }

    public void downloadVideo(String mediaId, Consumer<String> callback) {
        String token = this.weiXinTokenManager.getTokenFromLocal();
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/media/get/jssdk?access_token={0}&media_id={1}", token, mediaId);
        LoggerUtils.debug(logger, "\u4e0b\u8f7d\u4e34\u65f6\u89c6\u9891\u7d20\u6750url:{}", url);
        Mono mono = this.webClient.get().uri(url, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(JSONObject.class);
        mono.subscribe(obj -> {
            String videoUrl = obj.getString("video_url");
            LoggerUtils.debug(logger, "\u4e0b\u8f7d\u89c6\u9891\u4e34\u65f6\u7d20\u6750\u5fae\u4fe1\u51fa\u73b0\u5f02\u5e38\uff0cmediaId:{},\u8fd4\u56de:{}", mediaId, JSON.toJSONString((Object)obj));
            callback.accept(videoUrl);
        });
    }
}

