/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.function.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import net.jlxxw.component.weixin.enums.MaterialEnum;
import net.jlxxw.component.weixin.exception.WeiXinException;
import net.jlxxw.component.weixin.function.token.WeiXinTokenManager;
import net.jlxxw.component.weixin.util.LoggerUtils;
import net.jlxxw.component.weixin.vo.PermanentMaterialVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class PermanentMaterialManager {
    private static final Logger logger = LoggerFactory.getLogger(PermanentMaterialManager.class);
    @Autowired
    private WebClient webClient;
    @Autowired
    private WeiXinTokenManager weiXinTokenManager;

    @PostConstruct
    public void postConstruct() {
        Objects.requireNonNull(this.webClient);
        Objects.requireNonNull(this.weiXinTokenManager);
    }

    public void upload(MaterialEnum materialEnum, File file, Consumer<PermanentMaterialVO> callbackMethod) {
        String tokenFromLocal = this.weiXinTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/material/add_material?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750url:{}", url);
        this.postRequest(callbackMethod, (MultiValueMap<String, Object>)param, url);
    }

    public void upload(MaterialEnum materialEnum, URI uri, Consumer<PermanentMaterialVO> callbackMethod) {
        String tokenFromLocal = this.weiXinTokenManager.getTokenFromLocal();
        FileSystemResource resource = new FileSystemResource(Paths.get(uri));
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"type", (Object)materialEnum.name().toLowerCase());
        String url = MessageFormat.format("https https://api.weixin.qq.com/cgi-bin/material/add_material?access_token={0}&type={1}", tokenFromLocal, materialEnum.name().toLowerCase());
        LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750url:{}", url);
        this.postRequest(callbackMethod, (MultiValueMap<String, Object>)param, url);
    }

    public void download(String mediaId, Consumer<InputStream> callback) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"mediaId", (Object)mediaId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/get_material?access_token={0}", this.weiXinTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u4e0b\u8f7d\u6c38\u4e45\u7d20\u6750url:{}", url);
        Mono mono = ((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)param)).retrieve().bodyToMono(Resource.class);
        mono.subscribe(resource -> {
            try (InputStream inputStream = resource.getInputStream();){
                callback.accept(inputStream);
            }
            catch (Exception e) {
                LoggerUtils.error(logger, "\u4e0b\u8f7d\u6c38\u4e45\u7d20\u6750\u51fa\u73b0\u5f02\u5e38,mediaId:" + mediaId, e);
                throw new WeiXinException(e.getMessage());
            }
        });
    }

    public void delete(String mediaId) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"mediaId", (Object)mediaId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/material/del_material?access_token={0}", this.weiXinTokenManager.getTokenFromLocal());
        LoggerUtils.debug(logger, "\u5220\u9664\u6c38\u4e45\u7d20\u6750url:{}", url);
        Mono mono = ((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)param)).retrieve().bodyToMono(JSONObject.class);
        mono.subscribe(obj -> {
            if (obj.getInteger("errcode") != 0) {
                WeiXinException weiXinException = new WeiXinException(JSON.toJSONString((Object)obj));
                weiXinException.setErrorCode(obj.getInteger("errcode"));
                throw weiXinException;
            }
        });
    }

    private void postRequest(Consumer<PermanentMaterialVO> callbackMethod, MultiValueMap<String, Object> param, String url) {
        Mono mono = ((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromMultipartData(param)).retrieve().bodyToMono(JSONObject.class);
        mono.subscribe(obj -> {
            if (obj.getInteger("errcode") != null) {
                WeiXinException weiXinException = new WeiXinException(JSON.toJSONString((Object)obj));
                weiXinException.setErrorCode(obj.getInteger("errcode"));
                throw weiXinException;
            }
            LoggerUtils.debug(logger, "\u65b0\u589e\u6c38\u4e45\u7d20\u6750\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c:{}", JSON.toJSONString((Object)obj));
            PermanentMaterialVO materialVO = new PermanentMaterialVO();
            materialVO.setMediaId(obj.getString("media_id"));
            materialVO.setUrl(obj.getString("url"));
            callbackMethod.accept(materialVO);
        });
    }
}

