/*
 * Decompiled with CFR 0.152.
 */
package net.jlxxw.component.weixin.function.api;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Consumer;
import net.jlxxw.component.weixin.function.token.WeiXinTokenManager;
import net.jlxxw.component.weixin.properties.WeiXinProperties;
import net.jlxxw.component.weixin.response.WeiXinResponse;
import net.jlxxw.component.weixin.response.api.ApiRequestRecord;
import net.jlxxw.component.weixin.response.api.ApiResult;
import net.jlxxw.component.weixin.util.WebClientUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class OpenApiManager {
    @Autowired
    private WeiXinProperties weiXinProperties;
    @Autowired
    private WeiXinTokenManager weiXinTokenManager;
    @Autowired
    private WebClientUtils webClientUtils;

    public void clean(Consumer<WeiXinResponse> callback) {
        if (Objects.isNull(callback)) {
            throw new NullPointerException();
        }
        String appId = this.weiXinProperties.getAppId();
        String token = this.weiXinTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/clear_quota?access_token={0}", token);
        Mono<WeiXinResponse> weiXinResponseMono = this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), WeiXinResponse.class);
        weiXinResponseMono.subscribe(callback);
    }

    public void selectQuota(String cgiPath, Consumer<ApiResult> callback) {
        if (Objects.isNull(callback) || StringUtils.isBlank((String)cgiPath)) {
            throw new NullPointerException();
        }
        String appId = this.weiXinProperties.getAppId();
        String token = this.weiXinTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/quota/get?access_token={0}", token);
        Mono<ApiResult> weiXinResponseMono = this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), ApiResult.class);
        weiXinResponseMono.subscribe(callback);
    }

    private void selectRid(String rid, Consumer<ApiRequestRecord> callback) {
        if (Objects.isNull(callback) || StringUtils.isBlank((String)rid)) {
            throw new NullPointerException();
        }
        String appId = this.weiXinProperties.getAppId();
        String token = this.weiXinTokenManager.getTokenFromLocal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        String url = MessageFormat.format("https://api.weixin.qq.com/cgi-bin/openapi/quota/get?access_token={0}", token);
        Mono<ApiRequestRecord> weiXinResponseMono = this.webClientUtils.sendPostJSON(url, jsonObject.toJSONString(), ApiRequestRecord.class);
        weiXinResponseMono.subscribe(callback);
    }
}

